/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures.internal;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.CacheValidator;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.CacheFactory;
import org.gradle.cache.internal.filelock.LockOptions;
import org.gradle.internal.Factory;
import org.gradle.messaging.serialize.Serializer;
import org.gradle.testfixtures.internal.InMemoryIndexedCache;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryCacheFactory
implements CacheFactory {
    @Override
    public PersistentCache openStore(File storeDir, String displayName, LockOptions lockOptions, Action<? super PersistentCache> initializer) throws CacheOpenException {
        return this.open(storeDir, displayName, null, Collections.emptyMap(), lockOptions, initializer);
    }

    @Override
    public PersistentCache open(File cacheDir, String displayName, CacheValidator cacheValidator, Map<String, ?> properties, LockOptions lockOptions, Action<? super PersistentCache> initializer) {
        GFileUtils.mkdirs(cacheDir);
        InMemoryCache cache = new InMemoryCache(cacheDir);
        if (initializer != null) {
            initializer.execute((Object)cache);
        }
        return cache;
    }

    public <K, V> PersistentIndexedCache<K, V> openIndexedCache(File cacheDir, CacheValidator validator, Map<String, ?> properties, LockOptions lockOptions, Serializer<V> serializer) {
        return new InMemoryIndexedCache(serializer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InMemoryCache
    implements PersistentCache {
        private final File cacheDir;

        public InMemoryCache(File cacheDir) {
            this.cacheDir = cacheDir;
        }

        @Override
        public void close() {
        }

        @Override
        public File getBaseDir() {
            return this.cacheDir;
        }

        @Override
        public <K, V> PersistentIndexedCache<K, V> createCache(String name, Class<K> keyType, Serializer<V> valueSerializer) {
            return new InMemoryIndexedCache(valueSerializer);
        }

        @Override
        public <K, V> PersistentIndexedCache<K, V> createCache(PersistentIndexedCacheParameters<K, V> parameters) {
            return new InMemoryIndexedCache(parameters.getValueSerializer());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T useCache(String operationDisplayName, Factory<? extends T> action) {
            InMemoryCache inMemoryCache = this;
            synchronized (inMemoryCache) {
                return (T)action.create();
            }
        }

        @Override
        public void useCache(String operationDisplayName, Runnable action) {
            action.run();
        }

        @Override
        public <T> T longRunningOperation(String operationDisplayName, Factory<? extends T> action) {
            return (T)action.create();
        }

        @Override
        public void longRunningOperation(String operationDisplayName, Runnable action) {
            action.run();
        }
    }
}

