/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.reporting;

import java.io.File;
import java.io.Writer;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.html.SimpleHtmlWriter;
import org.gradle.reporting.ReportRenderer;
import org.gradle.reporting.TextReportRenderer;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlReportRenderer {
    private final Set<URL> resources = new HashSet<URL>();

    public void requireResource(URL resource) {
        this.resources.add(resource);
    }

    public <T> TextReportRenderer<T> renderer(final ReportRenderer<T, SimpleHtmlWriter> renderer) {
        return this.renderer(new TextReportRenderer<T>(){

            @Override
            protected void writeTo(T model, Writer writer) throws Exception {
                SimpleHtmlWriter htmlWriter = new SimpleHtmlWriter(writer, "");
                htmlWriter.startElement("html");
                renderer.render(model, htmlWriter);
                htmlWriter.endElement();
            }
        });
    }

    public <T> TextReportRenderer<T> renderer(final TextReportRenderer<T> renderer) {
        return new TextReportRenderer<T>(){

            @Override
            protected void writeTo(T model, Writer out) throws Exception {
                renderer.writeTo(model, out);
            }

            @Override
            public void writeTo(T model, File file) {
                super.writeTo(model, file);
                for (URL resource : HtmlReportRenderer.this.resources) {
                    String name = StringUtils.substringAfterLast((String)resource.getPath(), (String)"/");
                    String type = StringUtils.substringAfterLast((String)resource.getPath(), (String)".");
                    File destFile = new File(file.getParentFile(), String.format("%s/%s", type, name));
                    if (destFile.exists()) continue;
                    destFile.getParentFile().mkdirs();
                    GFileUtils.copyURLToFile(resource, destFile);
                }
            }
        };
    }
}

