/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.Factory;
import org.gradle.internal.jvm.Jvm;
import org.gradle.process.ProcessForkOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProcessForkOptions
implements ProcessForkOptions {
    private final FileResolver resolver;
    private Object executable;
    private Factory<File> workingDir;
    private final Map<String, Object> environment = new HashMap<String, Object>(Jvm.current().getInheritableEnvironmentVariables(System.getenv()));

    public DefaultProcessForkOptions(FileResolver resolver) {
        this.resolver = resolver;
        this.workingDir = resolver.resolveLater(".");
    }

    protected FileResolver getResolver() {
        return this.resolver;
    }

    @Override
    public String getExecutable() {
        return this.executable == null ? null : this.executable.toString();
    }

    @Override
    public void setExecutable(Object executable) {
        this.executable = executable;
    }

    @Override
    public ProcessForkOptions executable(Object executable) {
        this.setExecutable(executable);
        return this;
    }

    @Override
    public File getWorkingDir() {
        return (File)this.workingDir.create();
    }

    @Override
    public void setWorkingDir(Object dir) {
        this.workingDir = this.resolver.resolveLater(dir);
    }

    @Override
    public ProcessForkOptions workingDir(Object dir) {
        this.setWorkingDir(dir);
        return this;
    }

    @Override
    public Map<String, Object> getEnvironment() {
        return this.environment;
    }

    public Map<String, String> getActualEnvironment() {
        HashMap<String, String> actual = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.environment.entrySet()) {
            actual.put(entry.getKey(), String.valueOf(entry.getValue().toString()));
        }
        return actual;
    }

    @Override
    public void setEnvironment(Map<String, ?> environmentVariables) {
        this.environment.clear();
        this.environment.putAll(environmentVariables);
    }

    @Override
    public ProcessForkOptions environment(String name, Object value) {
        this.environment.put(name, value);
        return this;
    }

    @Override
    public ProcessForkOptions environment(Map<String, ?> environmentVariables) {
        this.environment.putAll(environmentVariables);
        return this;
    }

    @Override
    public ProcessForkOptions copyTo(ProcessForkOptions target) {
        target.setExecutable(this.executable);
        target.setWorkingDir(this.workingDir);
        target.setEnvironment(this.environment);
        return this;
    }
}

