/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.internal.Transformers;
import org.gradle.model.ModelPath;
import org.gradle.model.internal.DefaultInputs;
import org.gradle.model.internal.Inputs;
import org.gradle.model.internal.ModelCreationListener;
import org.gradle.model.internal.ModelCreator;
import org.gradle.model.internal.ModelMutation;
import org.gradle.model.internal.ModelMutator;
import org.gradle.model.internal.ModelRegistry;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelRegistry
implements ModelRegistry {
    private final Map<ModelPath, Object> store = new HashMap<ModelPath, Object>();
    private final Map<ModelPath, ModelCreation> creations = new HashMap<ModelPath, ModelCreation>();
    private final Multimap<ModelPath, ModelMutation<?>> mutators = ArrayListMultimap.create();
    private final Multimap<ModelPath, ImmutableList<ModelPath>> usedMutators = ArrayListMultimap.create();
    private final Multimap<ModelPath, ModelMutation<?>> finalizers = ArrayListMultimap.create();
    private final Multimap<ModelPath, ImmutableList<ModelPath>> usedFinalizers = ArrayListMultimap.create();
    private final List<ModelCreationListener> modelCreationListeners = new LinkedList<ModelCreationListener>();

    @Override
    public <T> void create(String path, List<String> inputPaths, ModelCreator<T> creator) {
        ModelPath creationModelPath = ModelPath.path(path);
        if (this.creations.containsKey(creationModelPath)) {
            throw new IllegalStateException("creator already registered for '" + creationModelPath + "'");
        }
        if (this.store.containsKey(creationModelPath)) {
            throw new IllegalStateException("model already created for '" + creationModelPath + "'");
        }
        this.notifyCreationListeners(creationModelPath, creator);
        this.creations.put(creationModelPath, new ModelCreation(creator, DefaultModelRegistry.toModelPaths(inputPaths)));
    }

    private static ImmutableList<ModelPath> toModelPaths(List<String> inputPaths) {
        return ImmutableList.copyOf((Collection)CollectionUtils.collect(inputPaths, (Transformer)new ToModelPath()));
    }

    @Override
    public <T> void mutate(String path, List<String> inputPaths, ModelMutator<T> mutator) {
        this.mutate(path, new ModelMutation<T>(mutator, DefaultModelRegistry.toModelPaths(inputPaths)));
    }

    @Override
    public <T> void mutate(String path, ModelMutation<T> mutation) {
        ModelPath mutationModelPath = this.assertNotFinalized(path);
        this.mutators.put((Object)mutationModelPath, mutation);
    }

    @Override
    public <T> void finalize(String path, List<String> inputPaths, ModelMutator<T> mutator) {
        this.finalize(path, new ModelMutation<T>(mutator, DefaultModelRegistry.toModelPaths(inputPaths)));
    }

    @Override
    public <T> void finalize(String path, ModelMutation<T> mutation) {
        ModelPath mutationModelPath = this.assertNotFinalized(path);
        this.finalizers.put((Object)mutationModelPath, mutation);
    }

    private ModelPath assertNotFinalized(String path) {
        ModelPath mutationModelPath = ModelPath.path(path);
        if (this.store.containsKey(mutationModelPath)) {
            throw new IllegalStateException("model '" + mutationModelPath + "' is finalized");
        }
        return mutationModelPath;
    }

    @Override
    public <T> T get(String path, Class<T> type) {
        ModelPath modelPath = ModelPath.path(path);
        Object model = this.getClosedModel(modelPath);
        if (type.isInstance(model)) {
            return type.cast(model);
        }
        throw new RuntimeException("Can't convert model at path '" + path + "' with type '" + model.getClass() + "' to target type '" + type + "'");
    }

    @Override
    public void registerListener(ModelCreationListener listener) {
        for (Map.Entry<ModelPath, ModelCreation> entry : this.creations.entrySet()) {
            boolean remove = listener.onCreate(entry.getKey(), entry.getValue().getCreator().getType());
            if (!remove) continue;
            return;
        }
        this.modelCreationListeners.add(listener);
    }

    @Override
    public void remove(String path) {
        ModelPath modelPath = ModelPath.path(path);
        if (this.creations.remove(modelPath) == null) {
            if (this.store.remove(modelPath) == null) {
                throw new RuntimeException("Tried to remove model " + path + " but it is not registered");
            }
            if (this.isDependedOn(modelPath)) {
                throw new RuntimeException("Tried to remove model " + path + " but it is depended on by other model elements");
            }
        }
    }

    private boolean isDependedOn(ModelPath candidate) {
        Transformer extractInputPaths = new Transformer<Iterable<ModelPath>, ModelMutation<?>>(){

            public Iterable<ModelPath> transform(ModelMutation<?> original) {
                return original.getInputPaths();
            }
        };
        Transformer passThrough = Transformers.noOpTransformer();
        return this.hasModelPath(candidate, this.mutators.values(), extractInputPaths) || this.hasModelPath(candidate, this.usedMutators.values(), passThrough) || this.hasModelPath(candidate, this.finalizers.values(), extractInputPaths) || this.hasModelPath(candidate, this.usedFinalizers.values(), passThrough);
    }

    private <T> boolean hasModelPath(ModelPath candidate, Iterable<T> things, Transformer<? extends Iterable<ModelPath>, T> transformer) {
        for (T thing : things) {
            for (ModelPath path : (Iterable)transformer.transform(thing)) {
                if (!path.equals(candidate)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<ModelPath> getPromisedPaths() {
        return ImmutableSet.builder().addAll(this.creations.keySet()).build();
    }

    private Object getClosedModel(ModelPath path) {
        ImmutableList<ModelPath> inputPaths;
        if (this.store.containsKey(path)) {
            return this.store.get(path);
        }
        Object model = this.createModel(path);
        Collection modelMutations = this.mutators.removeAll((Object)path);
        for (ModelMutation modelMutation : modelMutations) {
            this.fireMutation(model, modelMutation);
            inputPaths = modelMutation.getInputPaths();
            this.usedMutators.put((Object)path, inputPaths);
        }
        modelMutations = this.finalizers.removeAll((Object)path);
        for (ModelMutation modelMutation : modelMutations) {
            this.fireMutation(model, modelMutation);
            inputPaths = modelMutation.getInputPaths();
            this.usedFinalizers.put((Object)path, inputPaths);
        }
        Set<ModelPath> promisedPaths = this.getPromisedPaths();
        for (ModelPath modelPath : promisedPaths) {
            if (!path.isDirectChild(modelPath)) continue;
            this.getClosedModel(modelPath);
        }
        this.store.put(path, model);
        return model;
    }

    private Object createModel(ModelPath path) {
        ModelCreation creation = this.creations.remove(path);
        if (creation == null) {
            throw new IllegalStateException("No creator for '" + path + "'");
        }
        Inputs inputs = this.toInputs((Iterable<ModelPath>)creation.getInputPaths());
        Object created = creation.getCreator().create(inputs);
        this.store.put(path, created);
        return created;
    }

    private <T> void fireMutation(Object model, ModelMutation<T> modelMutation) {
        ModelMutator<T> mutator = modelMutation.getMutator();
        Inputs inputs = this.toInputs((Iterable<ModelPath>)modelMutation.getInputPaths());
        T cast = mutator.getType().cast(model);
        mutator.mutate(cast, inputs);
    }

    private Inputs toInputs(Iterable<ModelPath> inputPaths) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ModelPath inputPath : inputPaths) {
            builder.add(this.getClosedModel(inputPath));
        }
        return new DefaultInputs(builder.build());
    }

    private <T> void notifyCreationListeners(ModelPath path, ModelCreator<T> creator) {
        ListIterator<ModelCreationListener> modelCreationListenerListIterator = this.modelCreationListeners.listIterator();
        while (modelCreationListenerListIterator.hasNext()) {
            ModelCreationListener next = modelCreationListenerListIterator.next();
            boolean remove = next.onCreate(path, creator.getType());
            if (!remove) continue;
            modelCreationListenerListIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToModelPath
    implements Transformer<ModelPath, String> {
        private ToModelPath() {
        }

        public ModelPath transform(String string) {
            return ModelPath.path(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModelCreation {
        private final ModelCreator<?> creator;
        private final ImmutableList<ModelPath> inputPaths;

        public ModelCreation(ModelCreator<?> creator, ImmutableList<ModelPath> inputPaths) {
            this.creator = creator;
            this.inputPaths = inputPaths;
        }

        public ModelCreator<?> getCreator() {
            return this.creator;
        }

        public ImmutableList<ModelPath> getInputPaths() {
            return this.inputPaths;
        }
    }
}

