/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.model.ModelPath;
import org.gradle.model.ModelRules;
import org.gradle.model.dsl.ModelDsl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyModelDsl
extends GroovyObjectSupport
implements ModelDsl {
    private final ModelPath modelPath;
    private final ModelRules modelRules;
    private AtomicBoolean executingDsl;

    public GroovyModelDsl(ModelRules modelRules) {
        this(new AtomicBoolean(), null, modelRules);
    }

    private GroovyModelDsl(AtomicBoolean executingDsl, ModelPath modelPath, ModelRules modelRules) {
        this.executingDsl = executingDsl;
        this.modelPath = modelPath;
        this.modelRules = modelRules;
    }

    private GroovyModelDsl getChildPath(String name) {
        ModelPath path = this.modelPath == null ? ModelPath.path(name) : this.modelPath.child(name);
        return new GroovyModelDsl(this.executingDsl, path, this.modelRules);
    }

    private void registerConfigurationAction(Closure<?> action) {
        this.modelRules.config(this.modelPath.toString(), new ClosureBackedAction(action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Closure<?> action) {
        this.executingDsl.set(true);
        try {
            new ClosureBackedAction<GroovyModelDsl>(action).execute(this);
        }
        finally {
            this.executingDsl.set(false);
        }
    }

    public GroovyModelDsl propertyMissing(String name) {
        if (!this.executingDsl.get()) {
            throw new MissingPropertyException(name, this.getClass());
        }
        return this.getChildPath(name);
    }

    public Void methodMissing(String name, Object argsObj) {
        Object[] args = (Object[])argsObj;
        if (!this.executingDsl.get() || args.length != 1 || !(args[0] instanceof Closure)) {
            throw new MissingMethodException(name, this.getClass(), args);
        }
        Closure closure = (Closure)args[0];
        this.getChildPath(name).registerConfigurationAction(closure);
        return null;
    }
}

