/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.ProjectSpec;
import org.gradle.initialization.ProjectSpecs;

public class InstantiatingBuildLoader
implements BuildLoader {
    private final IProjectFactory projectFactory;

    public InstantiatingBuildLoader(IProjectFactory projectFactory) {
        this.projectFactory = projectFactory;
    }

    public void load(ProjectDescriptor rootProjectDescriptor, GradleInternal gradle, ClassLoaderScope baseClassLoaderScope) {
        this.createProjects(rootProjectDescriptor, gradle, baseClassLoaderScope);
        this.attachDefaultProject(gradle);
    }

    private void attachDefaultProject(GradleInternal gradle) {
        ProjectSpec spec = ProjectSpecs.forStartParameter(gradle.getStartParameter());
        try {
            gradle.setDefaultProject(spec.selectProject(gradle.getRootProject().getProjectRegistry()));
        }
        catch (InvalidUserDataException e) {
            throw new GradleException(String.format("Could not select the default project for this build. %s", e.getMessage()), (Throwable)((Object)e));
        }
    }

    private void createProjects(ProjectDescriptor rootProjectDescriptor, GradleInternal gradle, ClassLoaderScope baseClassLoaderScope) {
        ProjectInternal rootProject = this.projectFactory.createProject(rootProjectDescriptor, null, gradle, baseClassLoaderScope.createChild(), baseClassLoaderScope);
        gradle.setRootProject(rootProject);
        this.addProjects(rootProject, rootProjectDescriptor, gradle, baseClassLoaderScope);
    }

    private void addProjects(ProjectInternal parent, ProjectDescriptor parentProjectDescriptor, GradleInternal gradle, ClassLoaderScope baseClassLoaderScope) {
        for (ProjectDescriptor childProjectDescriptor : parentProjectDescriptor.getChildren()) {
            ProjectInternal childProject = this.projectFactory.createProject(childProjectDescriptor, parent, gradle, parent.getClassLoaderScope().createChild(), baseClassLoaderScope);
            this.addProjects(childProject, childProjectDescriptor, gradle, baseClassLoaderScope);
        }
    }
}

