/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.commandline;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.TaskParameter;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.options.OptionDescriptor;
import org.gradle.api.internal.tasks.options.OptionReader;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineOption;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.cli.ParsedCommandLineOption;
import org.gradle.execution.commandline.TaskConfigurationException;
import org.gradle.internal.DefaultTaskParameter;
import org.gradle.internal.typeconversion.TypeConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineTaskConfigurer {
    private OptionReader optionReader;

    public CommandLineTaskConfigurer(OptionReader optionReader) {
        this.optionReader = optionReader;
    }

    public List<TaskParameter> configureTasks(Collection<Task> tasks, List<TaskParameter> arguments) {
        assert (!tasks.isEmpty());
        if (arguments.isEmpty()) {
            return arguments;
        }
        return this.configureTasksNow(tasks, arguments);
    }

    private List<TaskParameter> configureTasksNow(Collection<Task> tasks, List<TaskParameter> arguments) {
        List remainingArguments = null;
        ArrayList argumentsOrParameters = Lists.newArrayList();
        ArrayList parameters = Lists.newArrayList();
        boolean notArgument = false;
        for (TaskParameter parameter : arguments) {
            if (parameter.getProjectPath() != null) {
                notArgument = true;
            }
            if (notArgument) {
                parameters.add(parameter);
                continue;
            }
            argumentsOrParameters.add(parameter.getTaskName());
        }
        for (Task task : tasks) {
            ParsedCommandLine parsed;
            CommandLineParser parser = new CommandLineParser();
            List<OptionDescriptor> commandLineOptions = this.optionReader.getOptions(task);
            for (OptionDescriptor optionDescriptor : commandLineOptions) {
                String optionName = optionDescriptor.getName();
                CommandLineOption option = parser.option(new String[]{optionName});
                option.hasDescription(optionDescriptor.getDescription());
                option.hasArgument(optionDescriptor.getArgumentType());
            }
            try {
                parsed = parser.parse((Iterable)argumentsOrParameters);
            }
            catch (CommandLineArgumentException e) {
                throw new TaskConfigurationException(task.getPath(), "Problem configuring task " + task.getPath() + " from command line.", (Exception)((Object)e));
            }
            for (OptionDescriptor commandLineOptionDescriptor : commandLineOptions) {
                String name = commandLineOptionDescriptor.getName();
                if (!parsed.hasOption(name)) continue;
                ParsedCommandLineOption o = parsed.option(name);
                try {
                    commandLineOptionDescriptor.apply(task, o.getValues());
                }
                catch (TypeConversionException ex) {
                    throw new TaskConfigurationException(task.getPath(), String.format("Problem configuring option '%s' on task '%s' from command line.", name, task.getPath()), ex);
                }
            }
            assert (remainingArguments == null || remainingArguments.equals(parsed.getExtraArguments())) : "we expect all options to be consumed by each task so remainingArguments should be the same for each task";
            remainingArguments = parsed.getExtraArguments();
        }
        return Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.transform(remainingArguments, (Function)new Function<String, TaskParameter>(){

            public TaskParameter apply(String input) {
                return new DefaultTaskParameter(input);
            }
        }), (Iterable)parameters));
    }
}

