/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.configuration.InitScriptProcessor;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.initialization.InitScript;

public class DefaultInitScriptProcessor
implements InitScriptProcessor {
    private final ScriptPluginFactory configurerFactory;
    private final ScriptHandlerFactory scriptHandlerFactory;

    public DefaultInitScriptProcessor(ScriptPluginFactory configurerFactory, ScriptHandlerFactory scriptHandlerFactory) {
        this.configurerFactory = configurerFactory;
        this.scriptHandlerFactory = scriptHandlerFactory;
    }

    public void process(ScriptSource initScript, GradleInternal gradle) {
        ClassLoaderScope baseScope = gradle.getClassLoaderScope();
        ClassLoaderScope scriptScope = baseScope.createSibling();
        ScriptHandler scriptHandler = this.scriptHandlerFactory.create(initScript, scriptScope);
        ScriptPlugin configurer = this.configurerFactory.create(initScript, scriptHandler, scriptScope, baseScope, "initscript", InitScript.class, false);
        configurer.apply(gradle);
    }
}

