/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.project.taskfactory.PropertyActionContext;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.internal.UncheckedException;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFilePropertyAnnotationHandler
implements PropertyAnnotationHandler {
    private final Class<? extends Annotation> annotationType;
    private final Transformer<Iterable<File>, Object> valueTransformer;
    private final ValidationAction outputDirValidation = new ValidationAction(){

        @Override
        public void validate(String propertyName, Object value, Collection<String> messages) {
            block0: for (File file : (Iterable)OutputFilePropertyAnnotationHandler.this.valueTransformer.transform(value)) {
                if (file.exists() && file.isDirectory()) {
                    messages.add(String.format("Cannot write to file '%s' specified for property '%s' as it is a directory.", file, propertyName));
                }
                for (File candidate = file.getParentFile(); candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
                    if (!candidate.exists() || candidate.isDirectory()) continue;
                    messages.add(String.format("Cannot write to file '%s' specified for property '%s', as ancestor '%s' is not a directory.", file, propertyName, candidate));
                    continue block0;
                }
            }
        }
    };

    public OutputFilePropertyAnnotationHandler(Class<? extends Annotation> annotationType, Transformer<Iterable<File>, Object> valueTransformer) {
        this.annotationType = annotationType;
        this.valueTransformer = valueTransformer;
    }

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    @Override
    public void attachActions(PropertyActionContext context) {
        context.setValidationAction(this.outputDirValidation);
        context.setConfigureAction(new UpdateAction(){

            @Override
            public void update(Task task, final Callable<Object> futureValue) {
                task.getOutputs().files(futureValue);
                task.doFirst((Action<? super Task>)new Action<Task>(){

                    public void execute(Task task) {
                        Iterable files;
                        try {
                            files = (Iterable)OutputFilePropertyAnnotationHandler.this.valueTransformer.transform(futureValue.call());
                        }
                        catch (Exception e) {
                            throw UncheckedException.throwAsUncheckedException((Throwable)e);
                        }
                        for (File file : files) {
                            file = GFileUtils.canonicalise(file);
                            GFileUtils.mkdirs(file.getParentFile());
                        }
                    }
                });
            }
        });
    }
}

