/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import groovy.lang.GroovyObject;
import groovy.lang.MissingPropertyException;
import groovy.util.ObservableMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Target;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ant.BasicAntBuilder;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.ant.AntTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAntBuilder
extends BasicAntBuilder
implements GroovyObject {
    private final Project gradleProject;

    public DefaultAntBuilder(Project gradleProject) {
        this.gradleProject = gradleProject;
    }

    public void propertyMissing(String property, Object newValue) {
        this.doSetProperty(property, newValue);
    }

    private void doSetProperty(String property, Object newValue) {
        PropertyHelper.getPropertyHelper((org.apache.tools.ant.Project)this.getProject()).setUserProperty(null, property, newValue);
    }

    public Object propertyMissing(String name) {
        if (this.getProject().getProperties().containsKey(name)) {
            return this.getProject().getProperties().get(name);
        }
        throw new MissingPropertyException(name, ((Object)((Object)this)).getClass());
    }

    @Override
    public Map<String, Object> getProperties() {
        ObservableMap map = new ObservableMap((Map)this.getProject().getProperties());
        map.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                DefaultAntBuilder.this.doSetProperty(event.getPropertyName(), event.getNewValue());
            }
        });
        ObservableMap castMap = map;
        return castMap;
    }

    @Override
    public Map<String, Object> getReferences() {
        ObservableMap map = new ObservableMap((Map)this.getProject().getReferences());
        map.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                DefaultAntBuilder.this.getProject().addReference(event.getPropertyName(), event.getNewValue());
            }
        });
        ObservableMap castMap = map;
        return castMap;
    }

    @Override
    public void importBuild(Object antBuildFile) {
        File file = this.gradleProject.file(antBuildFile);
        File baseDir = file.getParentFile();
        HashSet existingAntTargets = new HashSet(this.getAntProject().getTargets().keySet());
        File oldBaseDir = this.getAntProject().getBaseDir();
        this.getAntProject().setBaseDir(baseDir);
        try {
            this.getAntProject().setUserProperty("ant.file", file.getAbsolutePath());
            ProjectHelper.configureProject((org.apache.tools.ant.Project)this.getAntProject(), (File)file);
        }
        catch (Exception e) {
            throw new GradleException("Could not import Ant build file '" + String.valueOf(file) + "'.", (Throwable)e);
        }
        finally {
            this.getAntProject().setBaseDir(oldBaseDir);
        }
        this.getAntProject().getTargets().remove("");
        HashSet newAntTargets = new HashSet(this.getAntProject().getTargets().keySet());
        newAntTargets.removeAll(existingAntTargets);
        for (String name : newAntTargets) {
            Target target = (Target)this.getAntProject().getTargets().get(name);
            AntTarget task = this.gradleProject.getTasks().create(target.getName(), AntTarget.class);
            task.setTarget(target);
            task.setBaseDir(baseDir);
            this.addDependencyOrdering(target.getDependencies());
        }
    }

    private void addDependencyOrdering(Enumeration<String> dependencies) {
        TaskContainer tasks = this.gradleProject.getTasks();
        String previous = null;
        for (final String dependency : Collections.list(dependencies)) {
            if (previous != null) {
                final String finalPrevious = previous;
                tasks.all(new Action<Task>(){

                    public void execute(Task task) {
                        if (task.getName().equals(dependency)) {
                            task.shouldRunAfter(finalPrevious);
                        }
                    }
                });
            }
            previous = dependency;
        }
    }
}

