/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.internal.plugins.DefaultPluginCollection;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.plugins.PluginAware;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.UnknownPluginException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginContainer<T extends PluginAware>
extends DefaultPluginCollection<Plugin>
implements PluginContainer {
    private PluginRegistry pluginRegistry;
    private final T pluginAware;

    public DefaultPluginContainer(PluginRegistry pluginRegistry, T pluginAware) {
        super(Plugin.class);
        this.pluginRegistry = pluginRegistry;
        this.pluginAware = pluginAware;
    }

    @Override
    public Plugin apply(String id) {
        return this.addPluginInternal(this.getTypeForId(id));
    }

    public <P extends Plugin> P apply(Class<P> type) {
        return this.addPluginInternal(type);
    }

    @Override
    public boolean hasPlugin(String id) {
        return this.findPlugin(id) != null;
    }

    @Override
    public boolean hasPlugin(Class<? extends Plugin> type) {
        return this.findPlugin((Class)type) != null;
    }

    @Override
    public Plugin findPlugin(String id) {
        try {
            return this.findPlugin((Class)this.getTypeForId(id));
        }
        catch (UnknownPluginException e) {
            return null;
        }
    }

    public <P extends Plugin> P findPlugin(Class<P> type) {
        for (Plugin plugin : this) {
            if (!plugin.getClass().equals(type)) continue;
            return (P)((Plugin)type.cast(plugin));
        }
        return null;
    }

    private <P extends Plugin<?>> P addPluginInternal(Class<P> type) {
        if (this.findPlugin(type) == null) {
            Plugin<T> plugin = this.providePlugin(type);
            this.add(plugin);
        }
        return (P)((Plugin)type.cast(this.findPlugin(type)));
    }

    @Override
    public Plugin getPlugin(String id) {
        Plugin plugin = this.findPlugin(id);
        if (plugin == null) {
            throw new UnknownPluginException("Plugin with id " + id + " has not been used.");
        }
        return plugin;
    }

    @Override
    public Plugin getAt(String id) throws UnknownPluginException {
        return this.getPlugin(id);
    }

    public <P extends Plugin> P getAt(Class<P> type) throws UnknownPluginException {
        return this.getPlugin(type);
    }

    public <P extends Plugin> P getPlugin(Class<P> type) throws UnknownPluginException {
        P plugin = this.findPlugin(type);
        if (plugin == null) {
            throw new UnknownPluginException("Plugin with type " + type + " has not been used.");
        }
        return (P)((Plugin)type.cast(plugin));
    }

    @Override
    public void withId(String pluginId, Action<? super Plugin> action) {
        Class<Plugin> type = this.getTypeForId(pluginId);
        this.withType(type, action);
    }

    protected Class<? extends Plugin> getTypeForId(String id) {
        return this.pluginRegistry.getTypeForId(id);
    }

    private Plugin<T> providePlugin(Class<? extends Plugin<?>> type) {
        Plugin<?> plugin = this.pluginRegistry.loadPlugin(type);
        plugin.apply(this.pluginAware);
        return plugin;
    }
}

