/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import org.gradle.api.internal.initialization.ClassLoaderCache;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.DefaultClassLoaderScope;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootClassLoaderScope
implements ClassLoaderScope {
    private final ClassLoader classLoader;
    private final ClassLoaderCache classLoaderCache;

    public RootClassLoaderScope(ClassLoader classLoader, ClassLoaderCache classLoaderCache) {
        this.classLoader = classLoader;
        this.classLoaderCache = classLoaderCache;
    }

    @Override
    public ClassLoader getLocalClassLoader() {
        return this.classLoader;
    }

    @Override
    public ClassLoader getExportClassLoader() {
        return this.classLoader;
    }

    @Override
    public ClassLoaderScope getParent() {
        return this;
    }

    public Factory<ClassLoader> loader(final ClassPath classPath) {
        return new Factory<ClassLoader>(){

            public ClassLoader create() {
                return RootClassLoaderScope.this.classLoaderCache.get(RootClassLoaderScope.this.getExportClassLoader(), classPath, null);
            }
        };
    }

    @Override
    public ClassLoaderScope local(Factory<? extends ClassLoader> classLoader) {
        throw new UnsupportedOperationException("root class loader scope is immutable");
    }

    @Override
    public ClassLoaderScope export(Factory<? extends ClassLoader> classLoader) {
        throw new UnsupportedOperationException("root class loader scope is immutable");
    }

    @Override
    public ClassLoaderScope createSibling() {
        return this.createChild();
    }

    @Override
    public ClassLoaderScope createChild() {
        return new DefaultClassLoaderScope(this, this.classLoaderCache);
    }

    @Override
    public ClassLoaderScope lock() {
        return this;
    }

    @Override
    public boolean isLocked() {
        return true;
    }
}

