/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.internal.initialization.ClassLoaderCache;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.internal.Factory;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classpath.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassLoaderScope
implements ClassLoaderScope {
    public static final String STRICT_MODE_PROPERTY = "org.gradle.classloaderscope.strict";
    private final ClassLoaderScope parent;
    private final ClassLoaderCache classLoaderCache;
    private boolean locked;
    private List<Factory<? extends ClassLoader>> export = new LinkedList<Factory<? extends ClassLoader>>();
    private List<Factory<? extends ClassLoader>> local = new LinkedList<Factory<? extends ClassLoader>>();
    private MultiParentClassLoader exportingClassLoader;
    private MultiParentClassLoader localClassLoader;
    private ClassLoader effectiveLocalClassLoader;
    private ClassLoader effectiveExportClassLoader;

    public DefaultClassLoaderScope(ClassLoaderScope parent, ClassLoaderCache classLoaderCache) {
        this.parent = parent;
        this.classLoaderCache = classLoaderCache;
    }

    private MultiParentClassLoader buildLoader(ClassLoader parent, Collection<Factory<? extends ClassLoader>> rest) {
        ArrayList<Object> parents = new ArrayList<Object>(rest.size() + 1);
        parents.add(parent);
        for (Factory<? extends ClassLoader> factory : rest) {
            parents.add(factory.create());
        }
        return new MultiParentClassLoader(parents);
    }

    private CachingClassLoader buildCachingLoader(ClassLoader parent, Collection<Factory<? extends ClassLoader>> rest) {
        return new CachingClassLoader((ClassLoader)this.buildLoader(parent, rest));
    }

    private void buildEffectiveLoaders() {
        if (this.effectiveLocalClassLoader == null) {
            if (this.locked) {
                if (this.local.isEmpty() && this.export.isEmpty()) {
                    this.effectiveLocalClassLoader = this.parent.getExportClassLoader();
                    this.effectiveExportClassLoader = this.parent.getExportClassLoader();
                } else if (this.export.isEmpty()) {
                    this.effectiveLocalClassLoader = this.buildCachingLoader(this.parent.getExportClassLoader(), this.local);
                    this.effectiveExportClassLoader = this.parent.getExportClassLoader();
                } else if (this.local.isEmpty()) {
                    this.effectiveExportClassLoader = this.effectiveLocalClassLoader = this.buildCachingLoader(this.parent.getExportClassLoader(), this.export);
                } else {
                    this.effectiveExportClassLoader = this.buildCachingLoader(this.parent.getExportClassLoader(), this.export);
                    this.effectiveLocalClassLoader = this.buildCachingLoader(this.effectiveExportClassLoader, this.local);
                }
            } else {
                if (Boolean.getBoolean(STRICT_MODE_PROPERTY)) {
                    throw new IllegalStateException("Attempt to define scope class loader before scope is locked");
                }
                this.exportingClassLoader = this.buildLoader(this.parent.getExportClassLoader(), this.export);
                this.effectiveExportClassLoader = new CachingClassLoader((ClassLoader)this.exportingClassLoader);
                this.localClassLoader = this.buildLoader(this.effectiveExportClassLoader, this.local);
                this.effectiveLocalClassLoader = new CachingClassLoader((ClassLoader)this.localClassLoader);
            }
            this.export = null;
            this.local = null;
        }
    }

    @Override
    public ClassLoader getExportClassLoader() {
        this.buildEffectiveLoaders();
        return this.effectiveExportClassLoader;
    }

    @Override
    public ClassLoader getLocalClassLoader() {
        this.buildEffectiveLoaders();
        return this.effectiveLocalClassLoader;
    }

    @Override
    public ClassLoaderScope getParent() {
        return this.parent;
    }

    @Override
    public Factory<? extends ClassLoader> loader(final ClassPath classPath) {
        return new Factory<ClassLoader>(){

            public ClassLoader create() {
                return DefaultClassLoaderScope.this.classLoaderCache.get(DefaultClassLoaderScope.this.getExportClassLoader(), classPath, null);
            }
        };
    }

    @Override
    public ClassLoaderScope local(Factory<? extends ClassLoader> classLoader) {
        this.assertNotLocked();
        if (this.localClassLoader != null) {
            this.localClassLoader.addParent((ClassLoader)classLoader.create());
        } else {
            this.local.add(classLoader);
        }
        return this;
    }

    @Override
    public ClassLoaderScope export(Factory<? extends ClassLoader> classLoader) {
        this.assertNotLocked();
        if (this.exportingClassLoader != null) {
            this.exportingClassLoader.addParent((ClassLoader)classLoader.create());
        } else {
            this.export.add(classLoader);
        }
        return this;
    }

    private void assertNotLocked() {
        if (this.locked) {
            throw new IllegalStateException("class loader scope is locked");
        }
    }

    @Override
    public ClassLoaderScope createSibling() {
        return new DefaultClassLoaderScope(this.parent, this.classLoaderCache);
    }

    @Override
    public ClassLoaderScope createChild() {
        return new DefaultClassLoaderScope(this, this.classLoaderCache);
    }

    @Override
    public ClassLoaderScope lock() {
        this.locked = true;
        return this;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }
}

