/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.UnsupportedNotationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathNotationParser
implements NotationParser<Object, String> {
    @Override
    public void describe(Collection<String> candidateFormats) {
        candidateFormats.add("String or CharSequence instances e.g. 'some/path'");
        candidateFormats.add("Boolean values e.g. true, Boolean.TRUE");
        candidateFormats.add("Number values e.g. 42, 3.14");
        candidateFormats.add("A File instance");
        candidateFormats.add("A Closure that returns any supported value.");
        candidateFormats.add("A Callable that returns any supported value.");
    }

    public static NotationParser<Object, String> create() {
        return NotationParserBuilder.toType(String.class).noImplicitConverters().allowNullInput().parser(new PathNotationParser()).toComposite();
    }

    @Override
    public String parseNotation(Object notation) {
        if (notation == null) {
            return null;
        }
        if (notation instanceof CharSequence || notation instanceof File || notation instanceof Number || notation instanceof Boolean) {
            return notation.toString();
        }
        if (notation instanceof Closure) {
            Closure closure = (Closure)notation;
            Object called = closure.call();
            return this.parseNotation(called);
        }
        if (notation instanceof Callable) {
            try {
                Callable callableNotation = (Callable)notation;
                Object called = callableNotation.call();
                return this.parseNotation(called);
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        throw new UnsupportedNotationException(notation);
    }
}

