/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.scala;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.AntBuilder;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.compile.CompileSpec;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonManager;
import org.gradle.api.internal.tasks.scala.CleaningScalaCompiler;
import org.gradle.api.internal.tasks.scala.DefaultScalaJavaJointCompileSpec;
import org.gradle.api.internal.tasks.scala.DelegatingScalaCompiler;
import org.gradle.api.internal.tasks.scala.ScalaCompileSpec;
import org.gradle.api.internal.tasks.scala.ScalaCompilerFactory;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.scala.ScalaCompileOptions;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalaCompile
extends AbstractCompile {
    private static final Logger LOGGER = Logging.getLogger(ScalaCompile.class);
    private FileCollection scalaClasspath;
    private FileCollection zincClasspath;
    private Compiler<ScalaJavaJointCompileSpec> compiler;
    private final CompileOptions compileOptions = new CompileOptions();
    private final ScalaCompileOptions scalaCompileOptions = new ScalaCompileOptions();

    @Inject
    public ScalaCompile() {
    }

    @InputFiles
    public FileCollection getScalaClasspath() {
        return this.scalaClasspath;
    }

    public void setScalaClasspath(FileCollection scalaClasspath) {
        this.scalaClasspath = scalaClasspath;
    }

    @InputFiles
    public FileCollection getZincClasspath() {
        return this.zincClasspath;
    }

    public void setZincClasspath(FileCollection zincClasspath) {
        this.zincClasspath = zincClasspath;
    }

    @Nested
    public ScalaCompileOptions getScalaCompileOptions() {
        return this.scalaCompileOptions;
    }

    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }

    void setCompiler(Compiler<ScalaJavaJointCompileSpec> compiler) {
        this.compiler = compiler;
    }

    private Compiler<ScalaJavaJointCompileSpec> getCompiler() {
        if (this.compiler == null) {
            ProjectInternal projectInternal = (ProjectInternal)this.getProject();
            IsolatedAntBuilder antBuilder = (IsolatedAntBuilder)this.getServices().get(IsolatedAntBuilder.class);
            Factory antBuilderFactory = this.getServices().getFactory(AntBuilder.class);
            CompilerDaemonManager compilerDaemonManager = (CompilerDaemonManager)this.getServices().get(CompilerDaemonManager.class);
            ScalaCompilerFactory scalaCompilerFactory = new ScalaCompilerFactory(projectInternal, antBuilder, (Factory<AntBuilder>)antBuilderFactory, compilerDaemonManager);
            DelegatingScalaCompiler delegatingCompiler = new DelegatingScalaCompiler(scalaCompilerFactory);
            this.compiler = new CleaningScalaCompiler(delegatingCompiler, this.getOutputs());
        }
        return this.compiler;
    }

    @TaskAction
    protected void compile() {
        this.checkScalaClasspathIsNonEmpty();
        DefaultScalaJavaJointCompileSpec spec = new DefaultScalaJavaJointCompileSpec();
        spec.setSource((FileCollection)this.getSource());
        spec.setDestinationDir(this.getDestinationDir());
        spec.setClasspath((Iterable)this.getClasspath());
        spec.setScalaClasspath((Iterable<File>)this.getScalaClasspath());
        spec.setZincClasspath((Iterable<File>)this.getZincClasspath());
        spec.setSourceCompatibility(this.getSourceCompatibility());
        spec.setTargetCompatibility(this.getTargetCompatibility());
        spec.setCompileOptions(this.compileOptions);
        spec.setScalaCompileOptions(this.scalaCompileOptions);
        if (!this.scalaCompileOptions.isUseAnt()) {
            this.configureIncrementalCompilation(spec);
        }
        this.getCompiler().execute((CompileSpec)spec);
    }

    private void checkScalaClasspathIsNonEmpty() {
        if (this.getScalaClasspath().isEmpty()) {
            throw new InvalidUserDataException("'" + this.getName() + ".scalaClasspath' must not be empty. If a Scala compile dependency is provided, " + "the 'scala-base' plugin will attempt to configure 'scalaClasspath' automatically. Alternatively, you may configure 'scalaClasspath' explicitly.");
        }
    }

    private void configureIncrementalCompilation(ScalaCompileSpec spec) {
        Map<File, File> globalAnalysisMap = this.getOrCreateGlobalAnalysisMap();
        HashMap<File, File> filteredMap = this.filterForClasspath(globalAnalysisMap, spec.getClasspath());
        spec.setAnalysisMap(filteredMap);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Analysis file: {}", (Object)this.scalaCompileOptions.getIncrementalOptions().getAnalysisFile());
            LOGGER.debug("Published code: {}", (Object)this.scalaCompileOptions.getIncrementalOptions().getPublishedCode());
            LOGGER.debug("Analysis map: {}", filteredMap);
        }
    }

    private Map<File, File> getOrCreateGlobalAnalysisMap() {
        Map<File, File> analysisMap;
        ExtraPropertiesExtension extraProperties = this.getProject().getRootProject().getExtensions().getExtraProperties();
        if (extraProperties.has("scalaCompileAnalysisMap")) {
            analysisMap = (Map)extraProperties.get("scalaCompileAnalysisMap");
        } else {
            analysisMap = Maps.newHashMap();
            for (Project project : this.getProject().getRootProject().getAllprojects()) {
                for (ScalaCompile task : project.getTasks().withType(ScalaCompile.class)) {
                    if (task.getScalaCompileOptions().isUseAnt()) continue;
                    File publishedCode = task.getScalaCompileOptions().getIncrementalOptions().getPublishedCode();
                    File analysisFile = task.getScalaCompileOptions().getIncrementalOptions().getAnalysisFile();
                    analysisMap.put(publishedCode, analysisFile);
                }
            }
            extraProperties.set("scalaCompileAnalysisMap", Collections.unmodifiableMap(analysisMap));
        }
        return analysisMap;
    }

    private HashMap<File, File> filterForClasspath(Map<File, File> analysisMap, Iterable<File> classpath) {
        final HashSet classpathLookup = Sets.newHashSet(classpath);
        return Maps.newHashMap((Map)Maps.filterEntries(analysisMap, (Predicate)new Predicate<Map.Entry<File, File>>(){

            public boolean apply(Map.Entry<File, File> entry) {
                return classpathLookup.contains(entry.getKey());
            }
        }));
    }
}

