/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import org.gradle.api.AntBuilder;
import org.gradle.api.GradleException;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.compile.AntJavaCompiler;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonFactory;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonManager;
import org.gradle.api.internal.tasks.scala.AntScalaCompiler;
import org.gradle.api.internal.tasks.scala.DaemonScalaCompiler;
import org.gradle.api.internal.tasks.scala.DefaultScalaJavaJointCompiler;
import org.gradle.api.internal.tasks.scala.NormalizingScalaCompiler;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.scala.ScalaCompileOptions;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalaCompilerFactory {
    private final ProjectInternal project;
    private final IsolatedAntBuilder antBuilder;
    private final Factory<AntBuilder> antBuilderFactory;
    private final CompilerDaemonManager compilerDaemonManager;

    public ScalaCompilerFactory(ProjectInternal project, IsolatedAntBuilder antBuilder, Factory<AntBuilder> antBuilderFactory, CompilerDaemonManager compilerDaemonManager) {
        this.project = project;
        this.antBuilder = antBuilder;
        this.antBuilderFactory = antBuilderFactory;
        this.compilerDaemonManager = compilerDaemonManager;
    }

    public Compiler<ScalaJavaJointCompileSpec> create(ScalaCompileOptions scalaOptions, CompileOptions javaOptions) {
        Compiler scalaCompiler;
        if (scalaOptions.isUseAnt()) {
            AntScalaCompiler scalaCompiler2 = new AntScalaCompiler(this.antBuilder);
            AntJavaCompiler javaCompiler = new AntJavaCompiler(this.antBuilderFactory);
            return new DefaultScalaJavaJointCompiler(scalaCompiler2, (Compiler<JavaCompileSpec>)javaCompiler);
        }
        if (!scalaOptions.isFork()) {
            throw new GradleException("The Zinc based Scala compiler ('scalaCompileOptions.useAnt=false') requires forking ('scalaCompileOptions.fork=true'), but the latter is set to 'false'.");
        }
        try {
            scalaCompiler = (Compiler)this.getClass().getClassLoader().loadClass("org.gradle.api.internal.tasks.scala.jdk6.ZincScalaCompiler").newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Internal error: Failed to load org.gradle.api.internal.tasks.scala.jdk6.ZincScalaCompiler", e);
        }
        scalaCompiler = new DaemonScalaCompiler(this.project, (Compiler<ScalaJavaJointCompileSpec>)scalaCompiler, (CompilerDaemonFactory)this.compilerDaemonManager);
        return new NormalizingScalaCompiler((Compiler<ScalaJavaJointCompileSpec>)scalaCompiler);
    }
}

