/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.compile.CompileSpec;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.internal.tasks.compile.daemon.CompileResult;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemon;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonFactory;
import org.gradle.api.internal.tasks.compile.daemon.DaemonForkOptions;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.api.tasks.scala.ScalaForkOptions;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonScalaCompiler
implements Compiler<ScalaJavaJointCompileSpec> {
    private final ProjectInternal project;
    private final Compiler<ScalaJavaJointCompileSpec> delegate;
    private final CompilerDaemonFactory daemonFactory;

    public DaemonScalaCompiler(ProjectInternal project, Compiler<ScalaJavaJointCompileSpec> delegate, CompilerDaemonFactory daemonFactory) {
        this.project = project;
        this.delegate = delegate;
        this.daemonFactory = daemonFactory;
    }

    public WorkResult execute(ScalaJavaJointCompileSpec spec) {
        DaemonForkOptions daemonForkOptions = this.createDaemonForkOptions(spec);
        CompilerDaemon daemon = this.daemonFactory.getDaemon(this.project.getRootProject().getProjectDir(), daemonForkOptions);
        CompileResult result = daemon.execute(this.delegate, (CompileSpec)spec);
        if (result.isSuccess()) {
            return result;
        }
        throw UncheckedException.throwAsUncheckedException((Throwable)result.getException());
    }

    private DaemonForkOptions createDaemonForkOptions(ScalaJavaJointCompileSpec spec) {
        return this.createJavaForkOptions(spec).mergeWith(this.createScalaForkOptions(spec));
    }

    private DaemonForkOptions createJavaForkOptions(ScalaJavaJointCompileSpec spec) {
        ForkOptions options = spec.getCompileOptions().getForkOptions();
        return new DaemonForkOptions(options.getMemoryInitialSize(), options.getMemoryMaximumSize(), (Iterable)options.getJvmArgs());
    }

    private DaemonForkOptions createScalaForkOptions(ScalaJavaJointCompileSpec spec) {
        ScalaForkOptions options = spec.getScalaCompileOptions().getForkOptions();
        List<String> sharedPackages = Arrays.asList("scala", "com.typesafe.zinc", "xsbti", "com.sun.tools.javac");
        return new DaemonForkOptions(options.getMemoryInitialSize(), options.getMemoryMaximumSize(), (Iterable)options.getJvmArgs(), spec.getZincClasspath(), sharedPackages);
    }
}

