/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.gradle.internal.Factory;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.resource.transport.http.RepeatableInputStreamEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResourceUploader
implements ExternalResourceUploader {
    private final HttpClientHelper http;

    public HttpResourceUploader(HttpClientHelper http) {
        this.http = http;
    }

    public void upload(Factory<InputStream> source, Long contentLength, URI destination) throws IOException {
        HttpPut method = new HttpPut(destination);
        RepeatableInputStreamEntity entity = new RepeatableInputStreamEntity(source, contentLength, ContentType.APPLICATION_OCTET_STREAM);
        method.setEntity((HttpEntity)entity);
        HttpResponse response = this.http.performHttpRequest((HttpRequestBase)method);
        EntityUtils.consume((HttpEntity)response.getEntity());
        if (!this.http.wasSuccessful(response)) {
            throw new IOException(String.format("Could not PUT '%s'. Received status code %s from server: %s", destination, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
        }
    }
}

