/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.gradle.api.Nullable;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.resource.transport.http.HttpRequestException;
import org.gradle.internal.resource.transport.http.HttpResponseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResourceAccessor
implements ExternalResourceAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResourceAccessor.class);
    private final HttpClientHelper http;
    private final List<ExternalResource> openResources = new ArrayList<ExternalResource>();

    public HttpResourceAccessor(HttpClientHelper http) {
        this.http = http;
    }

    @Nullable
    public HttpResponseResource getResource(URI uri) throws IOException {
        this.abortOpenResources();
        String location = uri.toString();
        LOGGER.debug("Constructing external resource: {}", (Object)location);
        HttpResponse response = this.http.performGet(location);
        if (response != null) {
            HttpResponseResource resource = this.wrapResponse(uri, response);
            return this.recordOpenGetResource(resource);
        }
        return null;
    }

    public HttpResponseResource getRawResource(URI uri) throws IOException {
        HttpResponse response;
        this.abortOpenResources();
        String location = uri.toString();
        LOGGER.debug("Constructing external resource: {}", (Object)location);
        HttpGet request = new HttpGet(uri);
        try {
            response = this.http.performHttpRequest((HttpRequestBase)request);
        }
        catch (IOException e) {
            throw new HttpRequestException(String.format("Could not %s '%s'.", request.getMethod(), request.getURI()), e);
        }
        HttpResponseResource resource = this.wrapResponse(uri, response);
        return this.recordOpenGetResource(resource);
    }

    public ExternalResourceMetaData getMetaData(URI uri) {
        this.abortOpenResources();
        String location = uri.toString();
        LOGGER.debug("Constructing external resource metadata: {}", (Object)location);
        HttpResponse response = this.http.performHead(location);
        return response == null ? null : new HttpResponseResource("HEAD", uri, response).getMetaData();
    }

    private HttpResponseResource recordOpenGetResource(HttpResponseResource httpResource) {
        this.openResources.add((ExternalResource)httpResource);
        return httpResource;
    }

    private void abortOpenResources() {
        for (ExternalResource openResource : this.openResources) {
            LOGGER.warn("Forcing close on abandoned resource: " + openResource);
            try {
                openResource.close();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close abandoned resource", (Throwable)e);
            }
        }
        this.openResources.clear();
    }

    public HashValue getResourceSha1(URI location) {
        String checksumUrl = location + ".sha1";
        return this.downloadSha1(checksumUrl);
    }

    private HashValue downloadSha1(String checksumUrl) {
        try {
            HttpResponse httpResponse = this.http.performRawGet(checksumUrl);
            if (this.http.wasSuccessful(httpResponse)) {
                String checksumValue = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                return HashValue.parse((String)checksumValue);
            }
            if (!this.http.wasMissing(httpResponse)) {
                LOGGER.info("Request for checksum at {} failed: {}", (Object)checksumUrl, (Object)httpResponse.getStatusLine());
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.warn("Checksum missing at {} due to: {}", (Object)checksumUrl, (Object)e.getMessage());
            return null;
        }
    }

    private HttpResponseResource wrapResponse(URI uri, HttpResponse response) {
        return new HttpResponseResource("GET", uri, response){

            public void close() throws IOException {
                super.close();
                HttpResourceAccessor.this.openResources.remove((Object)this);
            }
        };
    }
}

