/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.LinkedHashSet;
import org.gradle.api.internal.classpath.EffectiveClassPath;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.util.DistributionLocator;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.Download;
import org.gradle.wrapper.GradleUserHomeLookup;
import org.gradle.wrapper.IDownload;
import org.gradle.wrapper.Install;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.WrapperConfiguration;
import org.gradle.wrapper.WrapperExecutor;

public class DistributionFactory {
    public Distribution getDefaultDistribution(File projectDir, boolean searchUpwards) {
        BuildLayout layout = new BuildLayoutFactory().getLayoutFor(projectDir, searchUpwards);
        WrapperExecutor wrapper = WrapperExecutor.forProjectDirectory((File)layout.getRootDirectory(), (Appendable)System.out);
        if (wrapper.getDistribution() != null) {
            return new ZippedDistribution(wrapper.getConfiguration());
        }
        return this.getDownloadedDistribution(GradleVersion.current().getVersion());
    }

    public Distribution getDistribution(File gradleHomeDir) {
        return new InstalledDistribution(gradleHomeDir, String.format("Gradle installation '%s'", gradleHomeDir), String.format("Gradle installation directory '%s'", gradleHomeDir));
    }

    public Distribution getDistribution(String gradleVersion) {
        return this.getDownloadedDistribution(gradleVersion);
    }

    public Distribution getDistribution(URI gradleDistribution) {
        WrapperConfiguration configuration = new WrapperConfiguration();
        configuration.setDistribution(gradleDistribution);
        return new ZippedDistribution(configuration);
    }

    public Distribution getClasspathDistribution() {
        return new ClasspathDistribution();
    }

    private Distribution getDownloadedDistribution(String gradleVersion) {
        URI distUri = new DistributionLocator().getDistributionFor(GradleVersion.version((String)gradleVersion));
        return this.getDistribution(distUri);
    }

    private static class ClasspathDistribution
    implements Distribution {
        private ClasspathDistribution() {
        }

        public String getDisplayName() {
            return "Gradle classpath distribution";
        }

        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory progressLoggerFactory, File userHomeDir) {
            return new EffectiveClassPath(this.getClass().getClassLoader());
        }
    }

    private static class InstalledDistribution
    implements Distribution {
        private final File gradleHomeDir;
        private final String displayName;
        private final String locationDisplayName;

        public InstalledDistribution(File gradleHomeDir, String displayName, String locationDisplayName) {
            this.gradleHomeDir = gradleHomeDir;
            this.displayName = displayName;
            this.locationDisplayName = locationDisplayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory progressLoggerFactory, File userHomeDir) {
            ProgressLogger progressLogger = progressLoggerFactory.newOperation(DistributionFactory.class);
            progressLogger.setDescription("Validate distribution");
            progressLogger.started();
            try {
                ClassPath classPath = this.getToolingImpl();
                return classPath;
            }
            finally {
                progressLogger.completed();
            }
        }

        private ClassPath getToolingImpl() {
            if (!this.gradleHomeDir.exists()) {
                throw new IllegalArgumentException(String.format("The specified %s does not exist.", this.locationDisplayName));
            }
            if (!this.gradleHomeDir.isDirectory()) {
                throw new IllegalArgumentException(String.format("The specified %s is not a directory.", this.locationDisplayName));
            }
            File libDir = new File(this.gradleHomeDir, "lib");
            if (!libDir.isDirectory()) {
                throw new IllegalArgumentException(String.format("The specified %s does not appear to contain a Gradle distribution.", this.locationDisplayName));
            }
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            for (File file : libDir.listFiles()) {
                if (!file.getName().endsWith(".jar")) continue;
                files.add(file);
            }
            return new DefaultClassPath(files);
        }
    }

    private static class ProgressReportingDownload
    implements IDownload {
        private final ProgressLoggerFactory progressLoggerFactory;

        private ProgressReportingDownload(ProgressLoggerFactory progressLoggerFactory) {
            this.progressLoggerFactory = progressLoggerFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void download(URI address, File destination) throws Exception {
            ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(DistributionFactory.class);
            progressLogger.setDescription(String.format("Download %s", address));
            progressLogger.started();
            try {
                new Download("Gradle Tooling API", GradleVersion.current().getVersion()).download(address, destination);
            }
            finally {
                progressLogger.completed();
            }
        }
    }

    private static class ZippedDistribution
    implements Distribution {
        private InstalledDistribution installedDistribution;
        private final WrapperConfiguration wrapperConfiguration;

        private ZippedDistribution(WrapperConfiguration wrapperConfiguration) {
            this.wrapperConfiguration = wrapperConfiguration;
        }

        public String getDisplayName() {
            return String.format("Gradle distribution '%s'", this.wrapperConfiguration.getDistribution());
        }

        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory progressLoggerFactory, File userHomeDir) {
            if (this.installedDistribution == null) {
                File installDir;
                try {
                    File realUserHomeDir = userHomeDir != null ? userHomeDir : GradleUserHomeLookup.gradleUserHome();
                    Install install = new Install((IDownload)new ProgressReportingDownload(progressLoggerFactory), new PathAssembler(realUserHomeDir));
                    installDir = install.createDist(this.wrapperConfiguration);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalArgumentException(String.format("The specified %s does not exist.", this.getDisplayName()), e);
                }
                catch (Exception e) {
                    throw new GradleConnectionException(String.format("Could not install Gradle distribution from '%s'.", this.wrapperConfiguration.getDistribution()), e);
                }
                this.installedDistribution = new InstalledDistribution(installDir, this.getDisplayName(), this.getDisplayName());
            }
            return this.installedDistribution.getToolingImplementationClasspath(progressLoggerFactory, userHomeDir);
        }
    }
}

