/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr.internal;

import antlr.Tool;
import antlr.preprocessor.GrammarFile;
import antlr.preprocessor.Hierarchy;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.antlr.internal.GrammarFileMetadata;
import org.gradle.api.plugins.antlr.internal.XRef;

public class MetadataExtracter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XRef extractMetadata(FileTree source) {
        Tool tool = new Tool();
        Hierarchy hierarchy = new Hierarchy(tool);
        for (File grammarFileFile : source.getFiles()) {
            String grammarFilePath = grammarFileFile.getPath();
            try {
                hierarchy.readGrammarFile(grammarFilePath);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Received FileNotFoundException on already read file", e);
            }
        }
        XRef xref = new XRef(hierarchy);
        for (File grammarFileFile : source.getFiles()) {
            String grammarPackageName = null;
            try {
                BufferedReader in = new BufferedReader(new FileReader(grammarFileFile));
                try {
                    String line;
                    while ((line = in.readLine()) != null) {
                        if (!(line = line.trim()).startsWith("package") || !line.endsWith(";")) continue;
                        grammarPackageName = line.substring(8, line.length() - 1);
                        break;
                    }
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException((Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String grammarFilePath = grammarFileFile.getPath();
            GrammarFile antlrGrammarFile = hierarchy.getFile(grammarFilePath);
            GrammarFileMetadata grammarFileMetadata = new GrammarFileMetadata(grammarFileFile, antlrGrammarFile, grammarPackageName);
            xref.addGrammarFile(grammarFileMetadata);
        }
        return xref;
    }
}

