/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.tasks;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.internal.dependencies.MavenDependencyInternal;
import org.gradle.api.publish.maven.internal.publication.MavenPomInternal;
import org.gradle.api.publish.maven.internal.tasks.MavenPomFileGenerator;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

@Incubating
public class GenerateMavenPom
extends DefaultTask {
    private MavenPom pom;
    private Object destination;

    public GenerateMavenPom() {
        this.getOutputs().upToDateWhen(Specs.satisfyNone());
    }

    @Inject
    protected FileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    public MavenPom getPom() {
        return this.pom;
    }

    public void setPom(MavenPom pom) {
        this.pom = pom;
    }

    @OutputFile
    public File getDestination() {
        return this.destination == null ? null : this.getFileResolver().resolve(this.destination);
    }

    public void setDestination(Object destination) {
        this.destination = destination;
    }

    @TaskAction
    public void doGenerate() {
        MavenPomInternal pomInternal = (MavenPomInternal)this.getPom();
        MavenPomFileGenerator pomGenerator = new MavenPomFileGenerator(pomInternal.getProjectIdentity());
        pomGenerator.setPackaging(pomInternal.getPackaging());
        for (MavenDependencyInternal runtimeDependency : pomInternal.getRuntimeDependencies()) {
            pomGenerator.addRuntimeDependency(runtimeDependency);
        }
        pomGenerator.withXml(pomInternal.getXmlAction());
        pomGenerator.writeTo(this.getDestination());
    }
}

