/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.artifact;

import java.io.File;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.artifact.DefaultMavenArtifact;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationParser;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenArtifactNotationParserFactory
implements Factory<NotationParser<Object, MavenArtifact>> {
    private final Instantiator instantiator;
    private final FileResolver fileResolver;

    public MavenArtifactNotationParserFactory(Instantiator instantiator, FileResolver fileResolver) {
        this.instantiator = instantiator;
        this.fileResolver = fileResolver;
    }

    public NotationParser<Object, MavenArtifact> create() {
        FileNotationParser fileNotationParser = new FileNotationParser(this.fileResolver);
        ArchiveTaskNotationParser archiveTaskNotationParser = new ArchiveTaskNotationParser();
        PublishArtifactNotationParser publishArtifactNotationParser = new PublishArtifactNotationParser();
        NotationParser sourceNotationParser = NotationParserBuilder.toType(MavenArtifact.class).fromType(AbstractArchiveTask.class, (NotationConverter)archiveTaskNotationParser).fromType(PublishArtifact.class, (NotationConverter)publishArtifactNotationParser).converter((NotationConverter)fileNotationParser).toComposite();
        MavenArtifactMapNotationParser mavenArtifactMapNotationParser = new MavenArtifactMapNotationParser(sourceNotationParser);
        NotationParserBuilder parserBuilder = NotationParserBuilder.toType(MavenArtifact.class).fromType(AbstractArchiveTask.class, (NotationConverter)archiveTaskNotationParser).fromType(PublishArtifact.class, (NotationConverter)publishArtifactNotationParser).parser((NotationParser)mavenArtifactMapNotationParser).converter((NotationConverter)fileNotationParser);
        return parserBuilder.toComposite();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MavenArtifactMapNotationParser
    extends MapNotationParser<MavenArtifact> {
        private final NotationParser<Object, MavenArtifact> sourceNotationParser;

        private MavenArtifactMapNotationParser(NotationParser<Object, MavenArtifact> sourceNotationParser) {
            this.sourceNotationParser = sourceNotationParser;
        }

        protected MavenArtifact parseMap(@MapKey(value="source") Object source) {
            return (MavenArtifact)this.sourceNotationParser.parseNotation(source);
        }

        public void describe(Collection<String> candidateFormats) {
            candidateFormats.add("Maps containing a 'source' entry, e.g. [source: '/path/to/file', extension: 'zip'].");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileNotationParser
    implements NotationConverter<Object, MavenArtifact> {
        private final NotationParser<Object, File> fileResolverNotationParser;

        private FileNotationParser(FileResolver fileResolver) {
            this.fileResolverNotationParser = fileResolver.asNotationParser();
        }

        public void convert(Object notation, NotationConvertResult<? super MavenArtifact> result) throws TypeConversionException {
            File file = (File)this.fileResolverNotationParser.parseNotation(notation);
            result.converted((Object)this.parseFile(file));
        }

        protected MavenArtifact parseFile(File file) {
            String extension = StringUtils.substringAfterLast((String)file.getName(), (String)".");
            return (MavenArtifact)MavenArtifactNotationParserFactory.this.instantiator.newInstance(DefaultMavenArtifact.class, new Object[]{file, extension, null});
        }

        public void describe(Collection<String> candidateFormats) {
            this.fileResolverNotationParser.describe(candidateFormats);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PublishArtifactNotationParser
    implements NotationConverter<PublishArtifact, MavenArtifact> {
        private PublishArtifactNotationParser() {
        }

        public void convert(PublishArtifact publishArtifact, NotationConvertResult<? super MavenArtifact> result) throws TypeConversionException {
            DefaultMavenArtifact artifact = (DefaultMavenArtifact)MavenArtifactNotationParserFactory.this.instantiator.newInstance(DefaultMavenArtifact.class, new Object[]{publishArtifact.getFile(), publishArtifact.getExtension(), publishArtifact.getClassifier()});
            artifact.builtBy(publishArtifact.getBuildDependencies());
            result.converted((Object)artifact);
        }

        public void describe(Collection<String> candidateFormats) {
            candidateFormats.add("Instances of PublishArtifact");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArchiveTaskNotationParser
    implements NotationConverter<AbstractArchiveTask, MavenArtifact> {
        private ArchiveTaskNotationParser() {
        }

        public void convert(AbstractArchiveTask archiveTask, NotationConvertResult<? super MavenArtifact> result) throws TypeConversionException {
            DefaultMavenArtifact artifact = (DefaultMavenArtifact)MavenArtifactNotationParserFactory.this.instantiator.newInstance(DefaultMavenArtifact.class, new Object[]{archiveTask.getArchivePath(), archiveTask.getExtension(), archiveTask.getClassifier()});
            artifact.builtBy(archiveTask);
            result.converted((Object)artifact);
        }

        public void describe(Collection<String> candidateFormats) {
            candidateFormats.add("Instances of AbstractArchiveTask e.g. jar");
        }
    }
}

