/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.artifact;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenArtifactSet;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.typeconversion.NotationParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMavenArtifactSet
extends DefaultDomainObjectSet<MavenArtifact>
implements MavenArtifactSet {
    private final String publicationName;
    private final TaskDependencyInternal builtBy = new ArtifactsTaskDependency();
    private final ArtifactsFileCollection files = new ArtifactsFileCollection();
    private final NotationParser<Object, MavenArtifact> mavenArtifactParser;

    public DefaultMavenArtifactSet(String publicationName, NotationParser<Object, MavenArtifact> mavenArtifactParser) {
        super(MavenArtifact.class);
        this.publicationName = publicationName;
        this.mavenArtifactParser = mavenArtifactParser;
    }

    @Override
    public MavenArtifact artifact(Object source) {
        MavenArtifact artifact = (MavenArtifact)this.mavenArtifactParser.parseNotation(source);
        this.add(artifact);
        return artifact;
    }

    @Override
    public MavenArtifact artifact(Object source, Action<? super MavenArtifact> config) {
        MavenArtifact artifact = this.artifact(source);
        config.execute((Object)artifact);
        return artifact;
    }

    public FileCollection getFiles() {
        return this.files;
    }

    private class ArtifactsTaskDependency
    extends AbstractTaskDependency {
        private ArtifactsTaskDependency() {
        }

        public void resolve(TaskDependencyResolveContext context) {
            Iterator i$ = DefaultMavenArtifactSet.this.iterator();
            while (i$.hasNext()) {
                MavenArtifact mavenArtifact = (MavenArtifact)i$.next();
                context.add((Object)mavenArtifact);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArtifactsFileCollection
    extends AbstractFileCollection {
        private ArtifactsFileCollection() {
        }

        public String getDisplayName() {
            return String.format("artifacts for " + DefaultMavenArtifactSet.this.publicationName + " publication", new Object[0]);
        }

        public TaskDependency getBuildDependencies() {
            return DefaultMavenArtifactSet.this.builtBy;
        }

        public Set<File> getFiles() {
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            Iterator i$ = DefaultMavenArtifactSet.this.iterator();
            while (i$.hasNext()) {
                MavenArtifact artifact = (MavenArtifact)i$.next();
                files.add(artifact.getFile());
            }
            return files;
        }
    }
}

