/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal;

import java.io.File;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.publish.maven.tasks.PublishToMavenLocal;
import org.gradle.api.publish.maven.tasks.PublishToMavenRepository;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.model.ModelRule;

public class MavenPublishTaskModelRule
extends ModelRule {
    private final Project project;
    private final Task publishLifecycleTask;
    private final Task publishLocalLifecycleTask;

    public MavenPublishTaskModelRule(Project project, Task publishLifecycleTask, Task publishLocalLifecycleTask) {
        this.project = project;
        this.publishLifecycleTask = publishLifecycleTask;
        this.publishLocalLifecycleTask = publishLocalLifecycleTask;
    }

    public void realizePublishingTasks(TaskContainer tasks, PublishingExtension extension) {
        PublicationContainer publications = extension.getPublications();
        for (MavenPublicationInternal publication : publications.withType(MavenPublicationInternal.class)) {
            String publicationName = publication.getName();
            this.createGeneratePomTask(publication, publicationName);
            this.createLocalInstallTask(tasks, publication, publicationName);
            this.createPublishTasksForEachMavenRepo(tasks, extension, publication, publicationName);
        }
    }

    private void createPublishTasksForEachMavenRepo(TaskContainer tasks, PublishingExtension extension, MavenPublicationInternal publication, String publicationName) {
        for (MavenArtifactRepository repository : extension.getRepositories().withType(MavenArtifactRepository.class)) {
            String repositoryName = repository.getName();
            String publishTaskName = String.format("publish%sPublicationTo%sRepository", StringUtils.capitalize((String)publicationName), StringUtils.capitalize((String)repositoryName));
            PublishToMavenRepository publishTask = (PublishToMavenRepository)tasks.create(publishTaskName, PublishToMavenRepository.class);
            publishTask.setPublication(publication);
            publishTask.setRepository(repository);
            publishTask.setGroup("publishing");
            publishTask.setDescription(String.format("Publishes Maven publication '%s' to Maven repository '%s'.", publicationName, repositoryName));
            this.publishLifecycleTask.dependsOn(new Object[]{publishTask});
        }
    }

    private void createLocalInstallTask(TaskContainer tasks, MavenPublicationInternal publication, String publicationName) {
        String installTaskName = String.format("publish%sPublicationToMavenLocal", StringUtils.capitalize((String)publicationName));
        PublishToMavenLocal publishLocalTask = (PublishToMavenLocal)tasks.create(installTaskName, PublishToMavenLocal.class);
        publishLocalTask.setPublication(publication);
        publishLocalTask.setGroup("publishing");
        publishLocalTask.setDescription(String.format("Publishes Maven publication '%s' to the local Maven repository.", publicationName));
        this.publishLocalLifecycleTask.dependsOn(new Object[]{installTaskName});
    }

    private void createGeneratePomTask(final MavenPublicationInternal publication, String publicationName) {
        String descriptorTaskName = String.format("generatePomFileFor%sPublication", StringUtils.capitalize((String)publicationName));
        GenerateMavenPom generatePomTask = (GenerateMavenPom)this.project.getTasks().create(descriptorTaskName, GenerateMavenPom.class);
        generatePomTask.setDescription(String.format("Generates the Maven POM file for publication '%s'.", publication.getName()));
        generatePomTask.setGroup("publishing");
        generatePomTask.setPom(publication.getPom());
        ConventionMapping descriptorTaskConventionMapping = new DslObject((Object)generatePomTask).getConventionMapping();
        descriptorTaskConventionMapping.map("destination", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return new File(MavenPublishTaskModelRule.this.project.getBuildDir(), "publications/" + publication.getName() + "/pom-default.xml");
            }
        });
        publication.setPomFile(generatePomTask.getOutputs().getFiles());
    }
}

