/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.ant.DeployTask;
import org.apache.maven.artifact.ant.InstallDeployTaskSupport;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.tools.ant.Project;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.maven.MavenDeployer;
import org.gradle.api.artifacts.maven.PomFilterContainer;
import org.gradle.api.publication.maven.internal.ArtifactPomContainer;
import org.gradle.api.publication.maven.internal.ant.AbstractMavenResolver;
import org.gradle.api.publication.maven.internal.ant.CustomDeployTask;
import org.gradle.logging.LoggingManagerInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseMavenDeployer
extends AbstractMavenResolver
implements MavenDeployer {
    private RemoteRepository remoteRepository;
    private RemoteRepository remoteSnapshotRepository;
    private Configuration configuration;
    private List<File> protocolProviderJars = new ArrayList<File>();
    private boolean uniqueVersion = true;

    public BaseMavenDeployer(PomFilterContainer pomFilterContainer, ArtifactPomContainer artifactPomContainer, LoggingManagerInternal loggingManager) {
        super(pomFilterContainer, artifactPomContainer, loggingManager);
    }

    @Override
    protected InstallDeployTaskSupport createPreConfiguredTask(Project project) {
        CustomDeployTask deployTask = this.createTask();
        deployTask.setProject(project);
        deployTask.setUniqueVersion(this.isUniqueVersion());
        this.addProtocolProvider(deployTask);
        this.addRemoteRepositories(deployTask);
        return deployTask;
    }

    protected CustomDeployTask createTask() {
        return new CustomDeployTask();
    }

    private void addProtocolProvider(CustomDeployTask deployTask) {
        PlexusContainer plexusContainer = deployTask.getContainer();
        for (File wagonProviderJar : this.getJars()) {
            try {
                plexusContainer.addJarResource(wagonProviderJar);
            }
            catch (PlexusContainerException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private List<File> getJars() {
        return this.configuration != null ? new ArrayList(this.configuration.resolve()) : this.protocolProviderJars;
    }

    private void addRemoteRepositories(DeployTask deployTask) {
        deployTask.addRemoteRepository(this.remoteRepository);
        deployTask.addRemoteSnapshotRepository(this.remoteSnapshotRepository);
    }

    public RemoteRepository getRepository() {
        return this.remoteRepository;
    }

    @Override
    public void setRepository(Object remoteRepository) {
        this.remoteRepository = (RemoteRepository)remoteRepository;
    }

    public RemoteRepository getSnapshotRepository() {
        return this.remoteSnapshotRepository;
    }

    @Override
    public void setSnapshotRepository(Object remoteSnapshotRepository) {
        this.remoteSnapshotRepository = (RemoteRepository)remoteSnapshotRepository;
    }

    @Override
    public void addProtocolProviderJars(Collection<File> jars) {
        this.protocolProviderJars.addAll(jars);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean isUniqueVersion() {
        return this.uniqueVersion;
    }

    @Override
    public void setUniqueVersion(boolean uniqueVersion) {
        this.uniqueVersion = uniqueVersion;
    }
}

