/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.repository.legacy.resolver.transform;

import org.gradle.mvn3.org.apache.maven.artifact.Artifact;
import org.gradle.mvn3.org.apache.maven.artifact.repository.ArtifactRepository;
import org.gradle.mvn3.org.apache.maven.artifact.repository.RepositoryRequest;
import org.gradle.mvn3.org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.gradle.mvn3.org.apache.maven.artifact.repository.metadata.Versioning;
import org.gradle.mvn3.org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.gradle.mvn3.org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.gradle.mvn3.org.apache.maven.repository.legacy.resolver.transform.AbstractVersionTransformation;
import org.gradle.mvn3.org.apache.maven.repository.legacy.resolver.transform.ArtifactTransformation;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Component;

@Component(role=ArtifactTransformation.class, hint="latest")
public class LatestArtifactTransformation
extends AbstractVersionTransformation {
    public void transformForResolve(Artifact artifact, RepositoryRequest request) throws ArtifactResolutionException, ArtifactNotFoundException {
        if ("LATEST".equals(artifact.getVersion())) {
            try {
                String version = this.resolveVersion(artifact, request);
                if ("LATEST".equals(version)) {
                    throw new ArtifactNotFoundException("Unable to determine the latest version", artifact);
                }
                artifact.setBaseVersion(version);
                artifact.updateVersion(version, request.getLocalRepository());
            }
            catch (RepositoryMetadataResolutionException e) {
                throw new ArtifactResolutionException(e.getMessage(), artifact, (Throwable)e);
            }
        }
    }

    public void transformForInstall(Artifact artifact, ArtifactRepository localRepository) {
    }

    public void transformForDeployment(Artifact artifact, ArtifactRepository remoteRepository, ArtifactRepository localRepository) {
    }

    protected String constructVersion(Versioning versioning, String baseVersion) {
        return versioning.getLatest();
    }
}

