/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.portal.internal;

import java.util.Map;
import org.gradle.api.GradleException;

class PluginUseMetaData {
    static final String M2_JAR = "M2_JAR";
    String id;
    String version;
    Map<String, String> implementation;
    String implementationType;

    PluginUseMetaData() {
    }

    void verify() {
        if (this.implementationType == null) {
            throw new GradleException("Invalid plugin metadata: No implementation type specified.");
        }
        if (!this.implementationType.equals(M2_JAR)) {
            throw new GradleException(String.format("Invalid plugin metadata: Unsupported implementation type: %s.", this.implementationType));
        }
        if (this.implementation == null) {
            throw new GradleException("Invalid plugin metadata: No implementation specified.");
        }
        if (this.implementation.get("gav") == null) {
            throw new GradleException("Invalid plugin metadata: No module coordinates specified.");
        }
        if (this.implementation.get("repo") == null) {
            throw new GradleException("Invalid plugin metadata: No module repository specified.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginUseMetaData that = (PluginUseMetaData)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.implementation.equals(that.implementation)) {
            return false;
        }
        if (!this.implementationType.equals(that.implementationType)) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.implementation.hashCode();
        result = 31 * result + this.implementationType.hashCode();
        return result;
    }
}

