/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.portal.internal;

import java.util.Set;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Nullable;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.configurations.ConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.StartParameterResolutionOverride;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestVersionMatcher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.SubVersionMatcher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionMatcher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionRangeMatcher;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.specs.Specs;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugin.use.internal.InvalidPluginRequestException;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.plugin.use.resolve.internal.ClassPathPluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.resolve.portal.internal.PluginPortalClient;
import org.gradle.plugin.use.resolve.portal.internal.PluginUseMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginPortalResolver
implements PluginResolver {
    public static final String OVERRIDE_URL_PROPERTY = PluginPortalResolver.class.getName() + ".repo.override";
    private static final String DEFAULT_API_URL = "http://plugins.gradle.org";
    private static final VersionMatcher RANGE_MATCHER = new VersionRangeMatcher(null);
    private static final VersionMatcher SUB_MATCHER = new SubVersionMatcher(null);
    private static final VersionMatcher LATEST_MATCHER = new LatestVersionMatcher();
    private final PluginPortalClient portalClient;
    private final Instantiator instantiator;
    private final StartParameter startParameter;
    private final Factory<DependencyResolutionServices> dependencyResolutionServicesFactory;
    private final ClassLoaderScope parentScope;

    public PluginPortalResolver(PluginPortalClient portalClient, Instantiator instantiator, StartParameter startParameter, ClassLoaderScope parentScope, Factory<DependencyResolutionServices> dependencyResolutionServicesFactory) {
        this.portalClient = portalClient;
        this.instantiator = instantiator;
        this.startParameter = startParameter;
        this.parentScope = parentScope;
        this.dependencyResolutionServicesFactory = dependencyResolutionServicesFactory;
    }

    private static String getUrl() {
        return System.getProperty(OVERRIDE_URL_PROPERTY, DEFAULT_API_URL);
    }

    @Override
    @Nullable
    public PluginResolution resolve(PluginRequest pluginRequest) throws InvalidPluginRequestException {
        this.validatePluginRequest(pluginRequest);
        PluginUseMetaData metaData = this.portalClient.queryPluginMetadata(pluginRequest, PluginPortalResolver.getUrl());
        if (metaData == null) {
            return null;
        }
        ClassPath classPath = this.resolvePluginDependencies(metaData);
        return new ClassPathPluginResolution(this.instantiator, pluginRequest.getId(), this.parentScope, (Factory<? extends ClassPath>)Factories.constant((Object)classPath));
    }

    private void validatePluginRequest(PluginRequest pluginRequest) {
        if (this.startParameter.isOffline()) {
            throw new GradleException(String.format("Plugin cannot be resolved from plugin portal because Gradle is running in offline mode.", new Object[0]));
        }
        if (pluginRequest.getVersion().endsWith("-SNAPSHOT")) {
            throw new InvalidPluginRequestException(pluginRequest, "Snapshot plugin versions are not supported.");
        }
        if (this.isDynamicVersion(pluginRequest.getVersion())) {
            throw new InvalidPluginRequestException(pluginRequest, "Dynamic plugin versions are not supported.");
        }
    }

    private boolean isDynamicVersion(String version) {
        return RANGE_MATCHER.canHandle(version) || SUB_MATCHER.canHandle(version) || LATEST_MATCHER.canHandle(version);
    }

    private ClassPath resolvePluginDependencies(final PluginUseMetaData metadata) {
        DependencyResolutionServices resolution = (DependencyResolutionServices)this.dependencyResolutionServicesFactory.create();
        RepositoryHandler repositories = resolution.getResolveRepositoryHandler();
        repositories.maven((Action)new Action<MavenArtifactRepository>(){

            public void execute(MavenArtifactRepository mavenArtifactRepository) {
                mavenArtifactRepository.setUrl((Object)metadata.implementation.get("repo"));
            }
        });
        Dependency dependency = resolution.getDependencyHandler().create((Object)metadata.implementation.get("gav"));
        ConfigurationContainerInternal configurations = resolution.getConfigurationContainer();
        ConfigurationInternal configuration = configurations.detachedConfiguration(new Dependency[]{dependency});
        StartParameterResolutionOverride resolutionOverride = new StartParameterResolutionOverride(this.startParameter);
        resolutionOverride.addResolutionRules(configuration.getResolutionStrategy().getResolutionRules());
        Set files = configuration.getResolvedConfiguration().getFiles(Specs.satisfyAll());
        return new DefaultClassPath((Iterable)files);
    }

    @Override
    public String getDescriptionForNotFoundMessage() {
        return "Plugin Portal (" + PluginPortalResolver.getUrl() + ")";
    }
}

