/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.portal.internal;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.gradle.api.GradleException;
import org.gradle.api.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.resource.transport.http.HttpResourceAccessor;
import org.gradle.internal.resource.transport.http.HttpResponseResource;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.plugin.use.resolve.portal.internal.ErrorResponse;
import org.gradle.plugin.use.resolve.portal.internal.PluginUseMetaData;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginPortalClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginPortalClient.class);
    private static final String REQUEST_URL = "/api/gradle/%s/plugin/use/%s/%s";
    private final HttpResourceAccessor resourceAccessor;

    public PluginPortalClient(HttpResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
    }

    @Nullable
    PluginUseMetaData queryPluginMetadata(PluginRequest pluginRequest, String portalUrl) {
        String requestUrl = String.format(portalUrl + REQUEST_URL, GradleVersion.current().getVersion(), pluginRequest.getId(), pluginRequest.getVersion());
        URI requestUri = this.toUri(requestUrl, "plugin request");
        HttpResponseResource response = null;
        try {
            response = this.resourceAccessor.getRawResource(requestUri);
            final int statusCode = response.getStatusCode();
            if (statusCode == 404) {
                PluginUseMetaData pluginUseMetaData = null;
                return pluginUseMetaData;
            }
            PluginUseMetaData pluginUseMetaData = (PluginUseMetaData)response.withContent((Transformer)new Transformer<PluginUseMetaData, InputStream>(){

                public PluginUseMetaData transform(InputStream inputStream) {
                    InputStreamReader reader;
                    try {
                        reader = new InputStreamReader(inputStream, "utf-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new AssertionError((Object)e);
                    }
                    try {
                        if (statusCode != 200) {
                            ErrorResponse errorResponse = (ErrorResponse)new Gson().fromJson((Reader)reader, ErrorResponse.class);
                            throw new GradleException(String.format("Plugin portal returned HTTP %d with message '%s'.", statusCode, errorResponse.message));
                        }
                        PluginUseMetaData metadata = (PluginUseMetaData)new Gson().fromJson((Reader)reader, PluginUseMetaData.class);
                        metadata.verify();
                        return metadata;
                    }
                    catch (JsonSyntaxException e) {
                        throw new GradleException("Failed to parse plugin portal JSON response.", (Throwable)e);
                    }
                    catch (JsonIOException e) {
                        throw new GradleException("Failed to read plugin portal JSON response.", (Throwable)e);
                    }
                }
            });
            return pluginUseMetaData;
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn("Error closing HTTP resource", (Throwable)e);
            }
        }
    }

    private URI toUri(String url, String kind) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new GradleException(String.format("Invalid %s URL: %s", kind, url, e));
        }
    }
}

