/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import org.gradle.api.internal.plugins.PluginDescriptor;
import org.gradle.api.internal.plugins.PluginDescriptorLocator;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.plugin.internal.PluginId;
import org.gradle.plugin.use.internal.InvalidPluginRequestException;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolver;

public class NotInPluginRegistryPluginResolverCheck
implements PluginResolver {
    private final PluginResolver delegate;
    private final PluginRegistry corePluginRegistry;
    private final PluginDescriptorLocator pluginDescriptorLocator;

    public NotInPluginRegistryPluginResolverCheck(PluginResolver delegate, PluginRegistry corePluginRegistry, PluginDescriptorLocator pluginDescriptorLocator) {
        this.delegate = delegate;
        this.corePluginRegistry = corePluginRegistry;
        this.pluginDescriptorLocator = pluginDescriptorLocator;
    }

    public PluginResolution resolve(PluginRequest pluginRequest) {
        PluginId pluginId = pluginRequest.getId();
        PluginDescriptor pluginDescriptor = this.pluginDescriptorLocator.findPluginDescriptor(pluginId.toString());
        if (pluginDescriptor == null || this.isCorePlugin(pluginId)) {
            return this.delegate.resolve(pluginRequest);
        }
        throw new InvalidPluginRequestException(pluginRequest, NotInPluginRegistryPluginResolverCheck.pluginOnClasspathErrorMessage(pluginId.toString()));
    }

    public static String pluginOnClasspathErrorMessage(String pluginId) {
        return String.format("Plugin '%s' is already on the script classpath. Plugins on the script classpath cannot be applied in the plugins {} block. Add  \"apply plugin: '%s'\" to the body of the script to use the plugin.", pluginId, pluginId);
    }

    private boolean isCorePlugin(PluginId pluginId) {
        try {
            this.corePluginRegistry.getTypeForId(pluginId.toString());
            return true;
        }
        catch (UnknownPluginException ignore) {
            return false;
        }
    }

    public String getDescriptionForNotFoundMessage() {
        return this.delegate.getDescriptionForNotFoundMessage();
    }
}

