/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.plugin.internal.PluginId;
import org.gradle.plugin.use.internal.InvalidPluginRequestException;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.resolve.internal.SimplePluginResolution;

public class CorePluginResolver
implements PluginResolver {
    public static final String CORE_PLUGIN_NAMESPACE = "org.gradle";
    private final DocumentationRegistry documentationRegistry;
    private final PluginRegistry pluginRegistry;

    public CorePluginResolver(DocumentationRegistry documentationRegistry, PluginRegistry pluginRegistry) {
        this.documentationRegistry = documentationRegistry;
        this.pluginRegistry = pluginRegistry;
    }

    public PluginResolution resolve(PluginRequest pluginRequest) {
        PluginId id = pluginRequest.getId();
        if (!id.isQualified() || id.inNamespace(CORE_PLUGIN_NAMESPACE)) {
            try {
                Class typeForId = this.pluginRegistry.getTypeForId(id.getName());
                if (pluginRequest.getVersion() != null) {
                    throw new InvalidPluginRequestException(pluginRequest, "Plugin '" + id + "' is a core Gradle plugin, which cannot be specified with a version number. " + "Such plugins are versioned as part of Gradle. Please remove the version number from the declaration.");
                }
                return new SimplePluginResolution(typeForId);
            }
            catch (UnknownPluginException e) {
                return null;
            }
        }
        return null;
    }

    public String toString() {
        return "Core Plugin Resolver";
    }

    public String getDescriptionForNotFoundMessage() {
        return String.format("Gradle Distribution Plugins (listing: %s)", this.documentationRegistry.getDocumentationFor("standard_plugins"));
    }
}

