/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.plugin.use.internal.PluginRequestApplicator;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginRequestApplicator
implements PluginRequestApplicator {
    private final PluginResolver pluginResolver;
    private final Action<? super PluginResolution> pluginResolutionHandler;

    public DefaultPluginRequestApplicator(PluginResolver pluginResolver, Action<? super PluginResolution> pluginResolutionHandler) {
        this.pluginResolver = pluginResolver;
        this.pluginResolutionHandler = pluginResolutionHandler;
    }

    public void applyPlugin(PluginRequest request) {
        PluginResolution resolution;
        try {
            resolution = this.pluginResolver.resolve(request);
        }
        catch (Exception e) {
            throw new LocationAwareException((Throwable)new GradleException(String.format("Error resolving plugin %s.", request.getDisplayName()), (Throwable)e), request.getScriptSource(), Integer.valueOf(request.getLineNumber()));
        }
        if (resolution == null) {
            throw new LocationAwareException((Throwable)new UnknownPluginException(String.format("Plugin %s not found in %s", request.getDisplayName(), this.pluginResolver.getDescriptionForNotFoundMessage())), request.getScriptSource(), Integer.valueOf(request.getLineNumber()));
        }
        this.pluginResolutionHandler.execute((Object)resolution);
    }
}

