/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.standalone;

import java.awt.BorderLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.gradle.gradleplugin.foundation.DOM4JSerializer;
import org.gradle.gradleplugin.foundation.ExtensionFileFilter;
import org.gradle.gradleplugin.foundation.settings.DOM4JSettingsNode;
import org.gradle.gradleplugin.foundation.settings.SettingsNode;
import org.gradle.gradleplugin.userinterface.AlternateUIInteraction;
import org.gradle.gradleplugin.userinterface.swing.common.PreferencesAssistant;
import org.gradle.gradleplugin.userinterface.swing.generic.BasicGradleUI;
import org.gradle.gradleplugin.userinterface.swing.generic.SinglePaneUIInstance;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.UncheckedException;

public class Application
implements AlternateUIInteraction {
    private static final int DEFAULT_WIDTH = 800;
    private static final int DEFAULT_HEIGHT = 800;
    private static final String WINDOW_PREFERENCES_ID = "window-id";
    private static final String SETTINGS_EXTENSION = ".setting";
    private JFrame frame;
    private SinglePaneUIInstance singlePaneUIInstance;
    private boolean doesSupportEditingFiles;
    private LifecycleListener lifecycleListener;
    private DOM4JSettingsNode rootSettingsNode;

    public Application(LifecycleListener lifecycleListener) {
        this.lifecycleListener = lifecycleListener;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        this.doesSupportEditingFiles = this.determineIfSupportsEditingFiles();
        this.rootSettingsNode = DOM4JSerializer.readSettingsFile(new SettingsImportInteraction(), this.createFileFilter());
        if (this.rootSettingsNode == null) {
            this.rootSettingsNode = DOM4JSerializer.createBlankSettings();
        }
        this.singlePaneUIInstance = new SinglePaneUIInstance();
        this.singlePaneUIInstance.initialize(this.rootSettingsNode, this);
        this.setupUI();
        this.restoreSettings();
        this.frame.setVisible(true);
    }

    private void setupUI() {
        this.frame = new JFrame("Gradle");
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.frame.getContentPane().add(mainPanel);
        mainPanel.add(this.singlePaneUIInstance.getComponent());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.singlePaneUIInstance.aboutToShow();
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Application.this.close();
            }
        });
        this.frame.setSize(800, 800);
        this.frame.setLocationByPlatform(true);
    }

    private void close() {
        boolean canClose = this.singlePaneUIInstance.canClose(new BasicGradleUI.CloseInteraction(){

            public boolean promptUserToConfirmClosingWhileBusy() {
                int result = JOptionPane.showConfirmDialog(Application.this.frame, "Gradle tasks are being currently being executed. Exit anyway?", "Exit While Busy?", 0, 3);
                return result == 0;
            }
        });
        if (!canClose) {
            return;
        }
        this.singlePaneUIInstance.close();
        this.saveSettings();
        this.frame.setVisible(false);
        if (this.lifecycleListener != null) {
            this.lifecycleListener.hasShutDown();
        } else {
            System.exit(0);
        }
    }

    private void saveSettings() {
        PreferencesAssistant.saveSettings((SettingsNode)this.rootSettingsNode, this.frame, WINDOW_PREFERENCES_ID, Application.class);
        DOM4JSerializer.exportToFile(new SettingsExportInteraction(), this.createFileFilter(), this.rootSettingsNode);
    }

    private void restoreSettings() {
        PreferencesAssistant.restoreSettings((SettingsNode)this.rootSettingsNode, this.frame, WINDOW_PREFERENCES_ID, Application.class);
    }

    public void openFile(File file, int line) {
        String name = file.getName().toLowerCase();
        if (name.endsWith(".html") || name.endsWith(".htm")) {
            this.browseFile(file);
        } else {
            this.editFile(file, line);
        }
    }

    public void browseFile(File file) {
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this.frame, "File does not exist '" + file.getAbsolutePath() + "'");
        } else if (!this.invokeDesktopFunction("browse", URI.class, file.toURI())) {
            String extension = Application.getFileNameExtension(file.getName());
            JOptionPane.showMessageDialog(this.frame, "Cannot browse file. Do you have an application assocated with '" + extension + "' files?");
        }
    }

    public void editFile(File file, int line) {
        this.editFileInExternalApplication(file, true);
    }

    public void editFileInExternalApplication(File file, boolean attemptToOpen) {
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this.frame, "File does not exist '" + file.getAbsolutePath() + "'");
        } else if (!this.invokeDesktopFunction("edit", File.class, file)) {
            this.openFileInExternalApplication(file);
        }
    }

    public void openFileInExternalApplication(File file) {
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this.frame, "File does not exist '" + file.getAbsolutePath() + "'");
        } else if (!this.invokeDesktopFunction("open", File.class, file)) {
            String extension = Application.getFileNameExtension(file.getName());
            JOptionPane.showMessageDialog(this.frame, "Cannot open file. Do you have an application assocated with '" + extension + "' files?");
        }
    }

    public boolean invokeDesktopFunction(String name, Class argumentClass, Object argument) {
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Method getDesktopMethod = desktopClass.getDeclaredMethod("getDesktop", null);
            Object desktopObject = getDesktopMethod.invoke(null, (Object[])null);
            if (desktopObject != null) {
                Method method = desktopClass.getMethod(name, argumentClass);
                method.invoke(desktopObject, argument);
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public static String getFileNameExtension(String fileName) {
        String result = fileName;
        int indexOfDot = fileName.lastIndexOf(46);
        if (indexOfDot > 0) {
            result = fileName.substring(indexOfDot + 1, result.length());
        }
        return result;
    }

    public boolean doesSupportEditingOpeningFiles() {
        return this.doesSupportEditingFiles;
    }

    public boolean determineIfSupportsEditingFiles() {
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Method getDesktopMethod = desktopClass.getDeclaredMethod("isDesktopSupported", null);
            Object desktopObject = getDesktopMethod.invoke(null, (Object[])null);
            return (Boolean)desktopObject;
        }
        catch (Exception e) {
            return false;
        }
    }

    private ExtensionFileFilter createFileFilter() {
        return new ExtensionFileFilter(SETTINGS_EXTENSION, "Setting");
    }

    private File getSettingsFile() {
        return new File(SystemProperties.getCurrentDir(), "gradle-app.setting");
    }

    private class SettingsExportInteraction
    implements DOM4JSerializer.ExportInteraction {
        private SettingsExportInteraction() {
        }

        public File promptForFile(FileFilter fileFilters) {
            return Application.this.getSettingsFile();
        }

        public boolean confirmOverwritingExistingFile(File file) {
            return true;
        }

        public void reportError(String error) {
            JOptionPane.showMessageDialog(Application.this.frame, "Failed to save settings: " + error);
        }
    }

    private class SettingsImportInteraction
    implements DOM4JSerializer.ImportInteraction {
        private SettingsImportInteraction() {
        }

        public File promptForFile(FileFilter fileFilters) {
            File settingsFile = Application.this.getSettingsFile();
            if (!settingsFile.exists()) {
                return null;
            }
            return settingsFile;
        }

        public void reportError(String error) {
            JOptionPane.showMessageDialog(Application.this.frame, "Failed to read settings: " + error);
        }
    }

    public static interface LifecycleListener {
        public void hasShutDown();
    }
}

