/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.generic.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.gradleplugin.foundation.GradlePluginLord;
import org.gradle.gradleplugin.foundation.settings.SettingsNode;
import org.gradle.gradleplugin.userinterface.swing.generic.OutputUILord;
import org.gradle.gradleplugin.userinterface.swing.generic.Utility;
import org.gradle.gradleplugin.userinterface.swing.generic.tabs.GradleTab;
import org.gradle.internal.SystemProperties;
import org.gradle.logging.ShowStacktrace;
import org.gradle.logging.internal.LoggingCommandLineConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetupTab
implements GradleTab,
GradlePluginLord.SettingsObserver {
    private final Logger logger = Logging.getLogger(SetupTab.class);
    private static final String STACK_TRACE_LEVEL_CLIENT_PROPERTY = "stack-trace-level-client-property";
    private static final String SETUP = "setup";
    private static final String STACK_TRACE_LEVEL = "stack-trace-level";
    private static final String SHOW_OUTPUT_ON_ERROR = "show-output-on-error";
    private static final String LOG_LEVEL = "log-level";
    private static final String CURRENT_DIRECTORY = "current-directory";
    private static final String CUSTOM_GRADLE_EXECUTOR = "custom-gradle-executor";
    private GradlePluginLord gradlePluginLord;
    private OutputUILord outputUILord;
    private SettingsNode settingsNode;
    private JPanel mainPanel;
    private JRadioButton showNoStackTraceRadioButton;
    private JRadioButton showStackTrackRadioButton;
    private JRadioButton showFullStackTrackRadioButton;
    private JComboBox logLevelComboBox;
    private JCheckBox onlyShowOutputOnErrorCheckBox;
    private ButtonGroup stackTraceButtonGroup;
    private JTextField currentDirectoryTextField;
    private JCheckBox useCustomGradleExecutorCheckBox;
    private JTextField customGradleExecutorField;
    private JButton browseForCustomGradleExecutorButton;
    private JPanel customPanelPlaceHolder;

    public SetupTab(GradlePluginLord gradlePluginLord, OutputUILord outputUILord, SettingsNode settingsNode) {
        this.gradlePluginLord = gradlePluginLord;
        this.outputUILord = outputUILord;
        this.settingsNode = settingsNode.addChildIfNotPresent(SETUP);
    }

    @Override
    public String getName() {
        return "Setup";
    }

    @Override
    public Component createComponent() {
        this.setupUI();
        return this.mainPanel;
    }

    @Override
    public void aboutToShow() {
        this.updatePluginLordSettings();
        this.gradlePluginLord.addSettingsObserver(this, true);
    }

    private void setupUI() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.add(this.createCurrentDirectoryPanel());
        this.mainPanel.add(Box.createVerticalStrut(10));
        this.mainPanel.add(this.createLogLevelPanel());
        this.mainPanel.add(Box.createVerticalStrut(10));
        this.mainPanel.add(this.createStackTracePanel());
        this.mainPanel.add(Box.createVerticalStrut(10));
        this.mainPanel.add(this.createOptionsPanel());
        this.mainPanel.add(Box.createVerticalStrut(10));
        this.mainPanel.add(this.createCustomExecutorPanel());
        this.mainPanel.add(Box.createVerticalStrut(10));
        this.customPanelPlaceHolder = new JPanel(new BorderLayout());
        this.mainPanel.add(this.customPanelPlaceHolder);
        JPanel expandingPanel = new JPanel(new BorderLayout());
        expandingPanel.add(Box.createVerticalGlue(), "Center");
        this.mainPanel.add(expandingPanel);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    private Component createCurrentDirectoryPanel() {
        this.currentDirectoryTextField = new JTextField();
        this.currentDirectoryTextField.setEditable(false);
        String currentDirectory = this.settingsNode.getValueOfChild(CURRENT_DIRECTORY, null);
        if (currentDirectory == null || "".equals(currentDirectory.trim())) {
            currentDirectory = this.gradlePluginLord.getCurrentDirectory().getAbsolutePath();
        }
        this.currentDirectoryTextField.setText(currentDirectory);
        this.gradlePluginLord.setCurrentDirectory(new File(currentDirectory));
        JButton browseButton = new JButton(new AbstractAction("Browse..."){

            public void actionPerformed(ActionEvent e) {
                File file = SetupTab.this.browseForDirectory(SetupTab.this.gradlePluginLord.getCurrentDirectory());
                if (file != null) {
                    SetupTab.this.setCurrentDirectory(file);
                }
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Utility.addLeftJustifiedComponent(new JLabel("Current Directory")));
        panel.add(SetupTab.createSideBySideComponent(this.currentDirectoryTextField, browseButton));
        return panel;
    }

    private void setCurrentDirectory(File file) {
        if (file == null) {
            this.currentDirectoryTextField.setText("");
            this.settingsNode.setValueOfChild(CURRENT_DIRECTORY, "");
        } else {
            this.currentDirectoryTextField.setText(file.getAbsolutePath());
            this.settingsNode.setValueOfChild(CURRENT_DIRECTORY, file.getAbsolutePath());
        }
        if (this.gradlePluginLord.setCurrentDirectory(file)) {
            this.gradlePluginLord.addRefreshRequestToQueue();
        }
    }

    public static JComponent createSideBySideComponent(Component leftComponent, Component rightComponent) {
        JPanel xLayoutPanel = new JPanel();
        xLayoutPanel.setLayout(new BoxLayout(xLayoutPanel, 0));
        Dimension preferredSize = leftComponent.getPreferredSize();
        leftComponent.setMaximumSize(new Dimension(Integer.MAX_VALUE, preferredSize.height));
        xLayoutPanel.add(leftComponent);
        xLayoutPanel.add(Box.createHorizontalStrut(5));
        xLayoutPanel.add(rightComponent);
        return xLayoutPanel;
    }

    private File browseForDirectory(File initialFile) {
        if (initialFile == null) {
            initialFile = SystemProperties.getCurrentDir();
        }
        JFileChooser chooser = new JFileChooser(initialFile);
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        File file = null;
        if (chooser.showOpenDialog(this.mainPanel) == 0) {
            file = chooser.getSelectedFile();
        }
        return file;
    }

    private Component createLogLevelPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.logLevelComboBox = new JComboBox<LogLevelWrapper>(this.getLogLevelWrappers());
        panel.add(Utility.addLeftJustifiedComponent(new JLabel("Log Level")));
        panel.add(Utility.addLeftJustifiedComponent(this.logLevelComboBox));
        String logLevelName = this.settingsNode.getValueOfChild(LOG_LEVEL, null);
        LogLevel logLevel = this.gradlePluginLord.getLogLevel();
        if (logLevelName != null) {
            try {
                logLevel = LogLevel.valueOf((String)logLevelName);
            }
            catch (IllegalArgumentException e) {
                this.logger.error("Converting log level text to log level enum '" + logLevelName + "'", (Throwable)e);
            }
        }
        this.gradlePluginLord.setLogLevel(logLevel);
        this.setLogLevelComboBoxSetting(logLevel);
        this.logLevelComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogLevelWrapper wrapper = (LogLevelWrapper)SetupTab.this.logLevelComboBox.getSelectedItem();
                if (wrapper != null) {
                    SetupTab.this.gradlePluginLord.setLogLevel(wrapper.logLevel);
                    SetupTab.this.settingsNode.setValueOfChild(SetupTab.LOG_LEVEL, wrapper.logLevel.name());
                }
            }
        });
        return panel;
    }

    private Vector<LogLevelWrapper> getLogLevelWrappers() {
        Set collection = new LoggingCommandLineConverter().getLogLevels();
        Vector<LogLevelWrapper> wrappers = new Vector<LogLevelWrapper>();
        for (LogLevel level : collection) {
            wrappers.add(new LogLevelWrapper(level));
        }
        Collections.sort(wrappers, new Comparator<LogLevelWrapper>(){

            @Override
            public int compare(LogLevelWrapper o1, LogLevelWrapper o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
        return wrappers;
    }

    private void setLogLevelComboBoxSetting(LogLevel logLevel) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.logLevelComboBox.getModel();
        for (int index = 0; index < model.getSize(); ++index) {
            LogLevelWrapper wrapper = (LogLevelWrapper)model.getElementAt(index);
            if (wrapper.logLevel != logLevel) continue;
            this.logLevelComboBox.setSelectedIndex(index);
            return;
        }
    }

    private Component createStackTracePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder("Stack Trace Output"));
        this.showNoStackTraceRadioButton = new JRadioButton("Exceptions Only");
        this.showStackTrackRadioButton = new JRadioButton("Standard Stack Trace (-s)");
        this.showFullStackTrackRadioButton = new JRadioButton("Full Stack Trace (-S)");
        this.showNoStackTraceRadioButton.putClientProperty(STACK_TRACE_LEVEL_CLIENT_PROPERTY, ShowStacktrace.INTERNAL_EXCEPTIONS);
        this.showStackTrackRadioButton.putClientProperty(STACK_TRACE_LEVEL_CLIENT_PROPERTY, ShowStacktrace.ALWAYS);
        this.showFullStackTrackRadioButton.putClientProperty(STACK_TRACE_LEVEL_CLIENT_PROPERTY, ShowStacktrace.ALWAYS_FULL);
        this.stackTraceButtonGroup = new ButtonGroup();
        this.stackTraceButtonGroup.add(this.showNoStackTraceRadioButton);
        this.stackTraceButtonGroup.add(this.showStackTrackRadioButton);
        this.stackTraceButtonGroup.add(this.showFullStackTrackRadioButton);
        this.showNoStackTraceRadioButton.setSelected(true);
        ActionListener radioButtonListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SetupTab.this.updateStackTraceSetting(true);
            }
        };
        this.showNoStackTraceRadioButton.addActionListener(radioButtonListener);
        this.showStackTrackRadioButton.addActionListener(radioButtonListener);
        this.showFullStackTrackRadioButton.addActionListener(radioButtonListener);
        panel.add(Utility.addLeftJustifiedComponent(this.showNoStackTraceRadioButton));
        panel.add(Utility.addLeftJustifiedComponent(this.showStackTrackRadioButton));
        panel.add(Utility.addLeftJustifiedComponent(this.showFullStackTrackRadioButton));
        String stackTraceLevel = this.settingsNode.getValueOfChild(STACK_TRACE_LEVEL, this.getSelectedStackTraceLevel().name());
        if (stackTraceLevel != null) {
            try {
                this.setSelectedStackTraceLevel(ShowStacktrace.valueOf((String)stackTraceLevel));
                this.updateStackTraceSetting(false);
            }
            catch (Exception e) {
                this.logger.error("Converting stack trace level text to stack trace level enum '" + stackTraceLevel + "'", (Throwable)e);
            }
        }
        return panel;
    }

    private void updateStackTraceSetting(boolean saveSetting) {
        ShowStacktrace stackTraceLevel = this.getSelectedStackTraceLevel();
        this.gradlePluginLord.setStackTraceLevel(stackTraceLevel);
        if (saveSetting) {
            this.settingsNode.setValueOfChild(STACK_TRACE_LEVEL, stackTraceLevel.name());
        }
    }

    private void setSelectedStackTraceLevel(ShowStacktrace newStackTraceLevel) {
        Enumeration<AbstractButton> buttonEnumeration = this.stackTraceButtonGroup.getElements();
        while (buttonEnumeration.hasMoreElements()) {
            JRadioButton radioButton = (JRadioButton)buttonEnumeration.nextElement();
            ShowStacktrace level = (ShowStacktrace)radioButton.getClientProperty(STACK_TRACE_LEVEL_CLIENT_PROPERTY);
            if (newStackTraceLevel != level) continue;
            radioButton.setSelected(true);
            return;
        }
    }

    private ShowStacktrace getSelectedStackTraceLevel() {
        ButtonModel selectedButtonModel = this.stackTraceButtonGroup.getSelection();
        if (selectedButtonModel != null) {
            Enumeration<AbstractButton> buttonEnumeration = this.stackTraceButtonGroup.getElements();
            while (buttonEnumeration.hasMoreElements()) {
                JRadioButton radioButton = (JRadioButton)buttonEnumeration.nextElement();
                if (radioButton.getModel() != selectedButtonModel) continue;
                ShowStacktrace level = (ShowStacktrace)radioButton.getClientProperty(STACK_TRACE_LEVEL_CLIENT_PROPERTY);
                return level;
            }
        }
        return ShowStacktrace.INTERNAL_EXCEPTIONS;
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.onlyShowOutputOnErrorCheckBox = new JCheckBox("Only Show Output When Errors Occur");
        this.onlyShowOutputOnErrorCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SetupTab.this.updateShowOutputOnErrorsSetting();
                SetupTab.this.settingsNode.setValueOfChildAsBoolean(SetupTab.SHOW_OUTPUT_ON_ERROR, SetupTab.this.onlyShowOutputOnErrorCheckBox.isSelected());
            }
        });
        boolean valueAsBoolean = this.settingsNode.getValueOfChildAsBoolean(SHOW_OUTPUT_ON_ERROR, this.onlyShowOutputOnErrorCheckBox.isSelected());
        this.onlyShowOutputOnErrorCheckBox.setSelected(valueAsBoolean);
        this.updateShowOutputOnErrorsSetting();
        panel.add(Utility.addLeftJustifiedComponent(this.onlyShowOutputOnErrorCheckBox));
        return panel;
    }

    private void updateShowOutputOnErrorsSetting() {
        boolean value = this.onlyShowOutputOnErrorCheckBox.isSelected();
        this.outputUILord.setOnlyShowOutputOnErrors(value);
    }

    private Component createCustomExecutorPanel() {
        this.useCustomGradleExecutorCheckBox = new JCheckBox("Use Custom Gradle Executor");
        this.customGradleExecutorField = new JTextField();
        this.customGradleExecutorField.setEditable(false);
        this.browseForCustomGradleExecutorButton = new JButton(new AbstractAction("Browse..."){

            public void actionPerformed(ActionEvent e) {
                SetupTab.this.browseForCustomGradleExecutor();
            }
        });
        String customExecutorPath = this.settingsNode.getValueOfChild(CUSTOM_GRADLE_EXECUTOR, null);
        if (customExecutorPath == null) {
            this.setCustomGradleExecutor(null);
        } else {
            this.setCustomGradleExecutor(new File(customExecutorPath));
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Utility.addLeftJustifiedComponent(this.useCustomGradleExecutorCheckBox));
        JComponent sideBySideComponent = SetupTab.createSideBySideComponent(this.customGradleExecutorField, this.browseForCustomGradleExecutorButton);
        sideBySideComponent.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
        panel.add(sideBySideComponent);
        this.useCustomGradleExecutorCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SetupTab.this.useCustomGradleExecutorCheckBox.isSelected()) {
                    SetupTab.this.browseForCustomGradleExecutor();
                } else {
                    SetupTab.this.setCustomGradleExecutor(null);
                }
            }
        });
        return panel;
    }

    private void browseForCustomGradleExecutor() {
        File startingDirectory = new File(SystemProperties.getUserHome());
        File currentFile = this.gradlePluginLord.getCustomGradleExecutor();
        if (currentFile != null) {
            startingDirectory = currentFile.getAbsoluteFile();
        } else if (this.gradlePluginLord.getCurrentDirectory() != null) {
            startingDirectory = this.gradlePluginLord.getCurrentDirectory();
        }
        JFileChooser chooser = new JFileChooser(startingDirectory);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        File file = null;
        if (chooser.showOpenDialog(this.mainPanel) == 0) {
            file = chooser.getSelectedFile();
        }
        if (file != null) {
            this.setCustomGradleExecutor(file);
        } else if (this.gradlePluginLord.getCustomGradleExecutor() == null) {
            this.setCustomGradleExecutor(null);
        }
    }

    private void setCustomGradleExecutor(File file) {
        String storagePath;
        boolean isUsingCustom = false;
        if (file == null) {
            isUsingCustom = false;
            storagePath = null;
        } else {
            isUsingCustom = true;
            storagePath = file.getAbsolutePath();
        }
        if (this.gradlePluginLord.setCustomGradleExecutor(file)) {
            this.gradlePluginLord.addRefreshRequestToQueue();
        }
        this.useCustomGradleExecutorCheckBox.setSelected(isUsingCustom);
        this.customGradleExecutorField.setText(storagePath);
        this.browseForCustomGradleExecutorButton.setEnabled(isUsingCustom);
        this.customGradleExecutorField.setEnabled(isUsingCustom);
        this.settingsNode.setValueOfChild(CUSTOM_GRADLE_EXECUTOR, storagePath);
    }

    public void setCustomPanel(JComponent component) {
        this.customPanelPlaceHolder.add((Component)component, "Center");
        this.customPanelPlaceHolder.invalidate();
        this.mainPanel.validate();
    }

    @Override
    public void settingsChanged() {
        this.updatePluginLordSettings();
    }

    private void updatePluginLordSettings() {
        this.setCustomGradleExecutor(this.gradlePluginLord.getCustomGradleExecutor());
        this.setCurrentDirectory(this.gradlePluginLord.getCurrentDirectory());
        this.setSelectedStackTraceLevel(this.gradlePluginLord.getStackTraceLevel());
        this.setLogLevelComboBoxSetting(this.gradlePluginLord.getLogLevel());
    }

    private class LogLevelWrapper {
        private LogLevel logLevel;
        private String toString;

        private LogLevelWrapper(LogLevel logLevel) {
            this.logLevel = logLevel;
            String temp = logLevel.toString().toLowerCase().replace('_', ' ');
            this.toString = Character.toUpperCase(temp.charAt(0)) + temp.substring(1);
            String commandLineCharacter = new LoggingCommandLineConverter().getLogLevelCommandLine(logLevel);
            if (commandLineCharacter != null && !commandLineCharacter.equals("")) {
                this.toString = this.toString + " (-" + commandLineCharacter + ")";
            }
        }

        public String toString() {
            return this.toString;
        }
    }
}

