/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.internal.batch;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.runner.RunnerException;
import org.sonar.runner.internal.batch.SonarRunnerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SonarProjectBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SonarProjectBuilder.class);
    private static final String PROPERTY_PROJECT_BASEDIR = "sonar.projectBaseDir";
    private static final String PROPERTY_PROJECT_CONFIG_FILE = "sonar.projectConfigFile";
    private static final String PROPERTY_PROJECT_KEY = "sonar.projectKey";
    private static final String PROPERTY_PROJECT_NAME = "sonar.projectName";
    private static final String PROPERTY_PROJECT_DESCRIPTION = "sonar.projectDescription";
    private static final String PROPERTY_PROJECT_VERSION = "sonar.projectVersion";
    private static final String PROPERTY_MODULES = "sonar.modules";
    private static final String PROPERTY_SOURCES = "sonar.sources";
    private static final String PROPERTY_TESTS = "sonar.tests";
    private static final String PROPERTY_BINARIES = "sonar.binaries";
    private static final String PROPERTY_LIBRARIES = "sonar.libraries";
    private static final String PROPERTY_OLD_SOURCES = "sources";
    private static final String PROPERTY_OLD_TESTS = "tests";
    private static final String PROPERTY_OLD_BINARIES = "binaries";
    private static final String PROPERTY_OLD_LIBRARIES = "libraries";
    private static final Map<String, String> DEPRECATED_PROPS_TO_NEW_PROPS = new HashMap<String, String>(){
        {
            this.put(SonarProjectBuilder.PROPERTY_OLD_SOURCES, SonarProjectBuilder.PROPERTY_SOURCES);
            this.put(SonarProjectBuilder.PROPERTY_OLD_TESTS, SonarProjectBuilder.PROPERTY_TESTS);
            this.put(SonarProjectBuilder.PROPERTY_OLD_BINARIES, SonarProjectBuilder.PROPERTY_BINARIES);
            this.put(SonarProjectBuilder.PROPERTY_OLD_LIBRARIES, SonarProjectBuilder.PROPERTY_LIBRARIES);
        }
    };
    private static final String PROPERTY_WORK_DIRECTORY = "sonar.working.directory";
    private static final String DEF_VALUE_WORK_DIRECTORY = ".sonar";
    private static final String[] MANDATORY_PROPERTIES_FOR_PROJECT = new String[]{"sonar.projectBaseDir", "sonar.projectKey", "sonar.projectName", "sonar.projectVersion", "sonar.sources"};
    private static final String[] MANDATORY_PROPERTIES_FOR_CHILD = new String[]{"sonar.projectKey", "sonar.projectName"};
    private static final List<String> NON_HERITED_PROPERTIES_FOR_CHILD = Lists.newArrayList((Object[])new String[]{"sonar.projectBaseDir", "sonar.modules", "sonar.projectDescription"});
    private Properties properties;
    private File rootProjectWorkDir;

    private SonarProjectBuilder(Properties properties) {
        this.properties = properties;
    }

    public static SonarProjectBuilder create(Properties properties) {
        return new SonarProjectBuilder(properties);
    }

    public ProjectDefinition generateProjectDefinition() {
        ProjectDefinition rootProject = this.defineProject(this.properties, null);
        this.rootProjectWorkDir = rootProject.getWorkDir();
        this.defineChildren(rootProject);
        SonarProjectBuilder.cleanAndCheckProjectDefinitions(rootProject);
        return rootProject;
    }

    private ProjectDefinition defineProject(Properties properties, ProjectDefinition parent) {
        SonarProjectBuilder.checkMandatoryProperties(properties, MANDATORY_PROPERTIES_FOR_PROJECT);
        File baseDir = new File(properties.getProperty(PROPERTY_PROJECT_BASEDIR));
        File workDir = null;
        workDir = parent == null ? this.initRootProjectWorkDir(baseDir) : this.initModuleWorkDir(properties);
        ProjectDefinition definition = ProjectDefinition.create((Properties)((Properties)properties.clone())).setBaseDir(baseDir).setWorkDir(workDir);
        return definition;
    }

    @VisibleForTesting
    protected File initRootProjectWorkDir(File baseDir) {
        String workDir = this.properties.getProperty(PROPERTY_WORK_DIRECTORY);
        if (StringUtils.isBlank((String)workDir)) {
            return new File(baseDir, DEF_VALUE_WORK_DIRECTORY);
        }
        File customWorkDir = new File(workDir);
        if (customWorkDir.isAbsolute()) {
            return customWorkDir;
        }
        return new File(baseDir, customWorkDir.getPath());
    }

    @VisibleForTesting
    protected File initModuleWorkDir(Properties properties) {
        String cleanKey = StringUtils.deleteWhitespace((String)properties.getProperty(PROPERTY_PROJECT_KEY));
        cleanKey = StringUtils.replace((String)cleanKey, (String)":", (String)"_");
        return new File(this.rootProjectWorkDir, cleanKey);
    }

    private void defineChildren(ProjectDefinition parentProject) {
        Properties parentProps = parentProject.getProperties();
        if (parentProps.containsKey(PROPERTY_MODULES)) {
            for (String module : SonarRunnerUtils.getListFromProperty(parentProps, PROPERTY_MODULES)) {
                Properties moduleProps = SonarProjectBuilder.extractModuleProperties(module, parentProps);
                ProjectDefinition childProject = this.loadChildProject(parentProject, moduleProps, module);
                SonarProjectBuilder.checkUnicityOfChildKey(childProject, parentProject);
                this.defineChildren(childProject);
                parentProject.addSubProject(childProject);
            }
        }
    }

    private ProjectDefinition loadChildProject(ProjectDefinition parentProject, Properties moduleProps, String moduleId) {
        SonarProjectBuilder.setProjectKeyAndNameIfNotDefined(moduleProps, moduleId);
        if (moduleProps.containsKey(PROPERTY_PROJECT_BASEDIR)) {
            File baseDir = SonarProjectBuilder.getFileFromPath(moduleProps.getProperty(PROPERTY_PROJECT_BASEDIR), parentProject.getBaseDir());
            SonarProjectBuilder.setProjectBaseDir(baseDir, moduleProps, moduleId);
            this.tryToFindAndLoadPropsFile(baseDir, moduleProps, moduleId);
        } else if (moduleProps.containsKey(PROPERTY_PROJECT_CONFIG_FILE)) {
            this.loadPropsFile(parentProject, moduleProps, moduleId);
        } else {
            File baseDir = new File(parentProject.getBaseDir(), moduleId);
            SonarProjectBuilder.setProjectBaseDir(baseDir, moduleProps, moduleId);
            this.tryToFindAndLoadPropsFile(baseDir, moduleProps, moduleId);
        }
        SonarProjectBuilder.checkMandatoryProperties(moduleProps, MANDATORY_PROPERTIES_FOR_CHILD);
        SonarProjectBuilder.mergeParentProperties(moduleProps, parentProject.getProperties());
        SonarProjectBuilder.prefixProjectKeyWithParentKey(moduleProps, parentProject.getKey());
        return this.defineProject(moduleProps, parentProject);
    }

    protected void loadPropsFile(ProjectDefinition parentProject, Properties moduleProps, String moduleId) {
        File propertyFile = SonarProjectBuilder.getFileFromPath(moduleProps.getProperty(PROPERTY_PROJECT_CONFIG_FILE), parentProject.getBaseDir());
        if (propertyFile.isFile()) {
            Properties propsFromFile = SonarProjectBuilder.toProperties(propertyFile);
            for (Map.Entry<Object, Object> entry : propsFromFile.entrySet()) {
                moduleProps.put(entry.getKey(), entry.getValue());
            }
        } else {
            throw new RunnerException("The properties file of the module '" + moduleId + "' does not exist: " + propertyFile.getAbsolutePath());
        }
        File baseDir = null;
        baseDir = moduleProps.containsKey(PROPERTY_PROJECT_BASEDIR) ? SonarProjectBuilder.getFileFromPath(moduleProps.getProperty(PROPERTY_PROJECT_BASEDIR), propertyFile.getParentFile()) : propertyFile.getParentFile();
        SonarProjectBuilder.setProjectBaseDir(baseDir, moduleProps, moduleId);
    }

    private void tryToFindAndLoadPropsFile(File baseDir, Properties moduleProps, String moduleId) {
        File propertyFile = new File(baseDir, "sonar-project.properties");
        if (propertyFile.isFile()) {
            Properties propsFromFile = SonarProjectBuilder.toProperties(propertyFile);
            for (Map.Entry<Object, Object> entry : propsFromFile.entrySet()) {
                moduleProps.put(entry.getKey(), entry.getValue());
            }
            if (moduleProps.containsKey(PROPERTY_PROJECT_BASEDIR)) {
                File overwrittenBaseDir = SonarProjectBuilder.getFileFromPath(moduleProps.getProperty(PROPERTY_PROJECT_BASEDIR), propertyFile.getParentFile());
                SonarProjectBuilder.setProjectBaseDir(overwrittenBaseDir, moduleProps, moduleId);
            }
        }
    }

    @VisibleForTesting
    protected static Properties toProperties(File propertyFile) {
        Properties propsFromFile = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(propertyFile);
            propsFromFile.load(fileInputStream);
        }
        catch (IOException e) {
            try {
                throw new RunnerException("Impossible to read the property file: " + propertyFile.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        return propsFromFile;
    }

    @VisibleForTesting
    protected static void setProjectKeyAndNameIfNotDefined(Properties childProps, String moduleId) {
        if (!childProps.containsKey(PROPERTY_PROJECT_KEY)) {
            childProps.put(PROPERTY_PROJECT_KEY, moduleId);
        }
        if (!childProps.containsKey(PROPERTY_PROJECT_NAME)) {
            childProps.put(PROPERTY_PROJECT_NAME, moduleId);
        }
    }

    @VisibleForTesting
    protected static void checkUnicityOfChildKey(ProjectDefinition childProject, ProjectDefinition parentProject) {
        for (ProjectDefinition definition : parentProject.getSubProjects()) {
            if (!definition.getKey().equals(childProject.getKey())) continue;
            throw new RunnerException("Project '" + parentProject.getKey() + "' can't have 2 modules with the following key: " + childProject.getKey());
        }
    }

    @VisibleForTesting
    protected static void prefixProjectKeyWithParentKey(Properties childProps, String parentKey) {
        String childKey = childProps.getProperty(PROPERTY_PROJECT_KEY);
        childProps.put(PROPERTY_PROJECT_KEY, parentKey + ":" + childKey);
    }

    private static void setProjectBaseDir(File baseDir, Properties childProps, String moduleId) {
        if (!baseDir.isDirectory()) {
            throw new RunnerException("The base directory of the module '" + moduleId + "' does not exist: " + baseDir.getAbsolutePath());
        }
        childProps.put(PROPERTY_PROJECT_BASEDIR, baseDir.getAbsolutePath());
    }

    @VisibleForTesting
    protected static void checkMandatoryProperties(Properties props, String[] mandatoryProps) {
        SonarProjectBuilder.replaceDeprecatedProperties(props);
        StringBuilder missing = new StringBuilder();
        for (String mandatoryProperty : mandatoryProps) {
            if (props.containsKey(mandatoryProperty)) continue;
            if (missing.length() > 0) {
                missing.append(", ");
            }
            missing.append(mandatoryProperty);
        }
        if (missing.length() != 0) {
            String projectKey = props.getProperty(PROPERTY_PROJECT_KEY);
            throw new RunnerException("You must define the following mandatory properties for '" + (projectKey == null ? "Unknown" : projectKey) + "': " + missing);
        }
    }

    @VisibleForTesting
    protected static void cleanAndCheckProjectDefinitions(ProjectDefinition project) {
        if (project.getSubProjects().isEmpty()) {
            SonarProjectBuilder.cleanAndCheckModuleProperties(project);
        } else {
            SonarProjectBuilder.cleanAggregatorProjectProperties(project);
            for (ProjectDefinition module : project.getSubProjects()) {
                SonarProjectBuilder.cleanAndCheckProjectDefinitions(module);
            }
        }
    }

    @VisibleForTesting
    protected static void cleanAndCheckModuleProperties(ProjectDefinition project) {
        Properties properties = project.getProperties();
        String[] sourceDirs = SonarRunnerUtils.getListFromProperty(properties, PROPERTY_SOURCES);
        SonarProjectBuilder.checkExistenceOfDirectories(project.getKey(), project.getBaseDir(), sourceDirs);
        ArrayList libPaths = Lists.newArrayList();
        for (String pattern : SonarRunnerUtils.getListFromProperty(properties, PROPERTY_LIBRARIES)) {
            for (File file : SonarProjectBuilder.getLibraries(project.getBaseDir(), pattern)) {
                libPaths.add(file.getAbsolutePath());
            }
        }
        properties.remove(PROPERTY_LIBRARIES);
        properties.put(PROPERTY_LIBRARIES, StringUtils.join((Collection)libPaths, (String)","));
    }

    @VisibleForTesting
    protected static void cleanAggregatorProjectProperties(ProjectDefinition project) {
        Properties properties = project.getProperties();
        properties.remove(PROPERTY_SOURCES);
        properties.remove(PROPERTY_TESTS);
        properties.remove(PROPERTY_BINARIES);
        properties.remove(PROPERTY_LIBRARIES);
        Properties clone = (Properties)properties.clone();
        ArrayList moduleIds = Lists.newArrayList((Object[])SonarRunnerUtils.getListFromProperty(properties, PROPERTY_MODULES));
        for (Map.Entry<Object, Object> entry : clone.entrySet()) {
            String key = (String)entry.getKey();
            if (!SonarProjectBuilder.isKeyPrefixedByModuleId(key, moduleIds)) continue;
            properties.remove(key);
        }
    }

    @VisibleForTesting
    protected static void replaceDeprecatedProperties(Properties props) {
        for (Map.Entry<String, String> entry : DEPRECATED_PROPS_TO_NEW_PROPS.entrySet()) {
            String key = entry.getKey();
            if (!props.containsKey(key)) continue;
            String newKey = entry.getValue();
            LOG.warn("/!\\ The '{}' property is deprecated and is replaced by '{}'. Don't forget to update your files.", (Object)key, (Object)newKey);
            String value = props.getProperty(key);
            props.remove(key);
            props.put(newKey, value);
        }
    }

    @VisibleForTesting
    protected static void mergeParentProperties(Properties childProps, Properties parentProps) {
        ArrayList moduleIds = Lists.newArrayList((Object[])SonarRunnerUtils.getListFromProperty(parentProps, PROPERTY_MODULES));
        for (Map.Entry<Object, Object> entry : parentProps.entrySet()) {
            String key = (String)entry.getKey();
            if (childProps.containsKey(key) || NON_HERITED_PROPERTIES_FOR_CHILD.contains(key) || SonarProjectBuilder.isKeyPrefixedByModuleId(key, moduleIds)) continue;
            childProps.put(entry.getKey(), entry.getValue());
        }
    }

    private static boolean isKeyPrefixedByModuleId(String key, List<String> moduleIds) {
        for (String moduleId : moduleIds) {
            if (!key.startsWith(moduleId + ".")) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    protected static Properties extractModuleProperties(String module, Properties properties) {
        Properties moduleProps = new Properties();
        String propertyPrefix = module + ".";
        int prefixLength = propertyPrefix.length();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(propertyPrefix)) continue;
            moduleProps.put(key.substring(prefixLength), entry.getValue());
        }
        return moduleProps;
    }

    @VisibleForTesting
    protected static void checkExistenceOfDirectories(String projectKey, File baseDir, String[] sourceDirs) {
        for (String path : sourceDirs) {
            File sourceFolder = SonarProjectBuilder.getFileFromPath(path, baseDir);
            if (sourceFolder.isDirectory()) continue;
            throw new RunnerException("The folder '" + path + "' does not exist for '" + projectKey + "' project (base directory = " + baseDir.getAbsolutePath() + ")");
        }
    }

    @VisibleForTesting
    protected static File[] getLibraries(File baseDir, String pattern) {
        String filePattern;
        String dirPath;
        int i = Math.max(pattern.lastIndexOf(47), pattern.lastIndexOf(92));
        if (i == -1) {
            dirPath = ".";
            filePattern = pattern;
        } else {
            dirPath = pattern.substring(0, i);
            filePattern = pattern.substring(i + 1);
        }
        AndFileFilter fileFilter = new AndFileFilter(FileFileFilter.FILE, (IOFileFilter)new WildcardFileFilter(filePattern));
        File dir = SonarProjectBuilder.resolvePath(baseDir, dirPath);
        File[] files = dir.listFiles((FileFilter)fileFilter);
        if (files == null || files.length == 0) {
            throw new RunnerException("No files matching pattern \"" + filePattern + "\" in directory \"" + dir + "\"");
        }
        return files;
    }

    private static File resolvePath(File baseDir, String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            try {
                file = new File(baseDir, path).getCanonicalFile();
            }
            catch (IOException e) {
                throw new RunnerException("Unable to resolve path \"" + path + "\"", e);
            }
        }
        return file;
    }

    @VisibleForTesting
    protected static File getFileFromPath(String path, File baseDir) {
        File propertyFile = new File(path.trim());
        if (!propertyFile.isAbsolute()) {
            propertyFile = new File(baseDir, propertyFile.getPath());
        }
        return propertyFile;
    }
}

