/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.sonar.runner.IOUtils;
import org.sonar.runner.Logs;
import org.sonar.runner.Runner;
import org.sonar.runner.RunnerException;
import org.sonar.runner.Stats;
import org.sonar.runner.Version;

public final class Main {
    private static final String RUNNER_HOME = "runner.home";
    private static final String RUNNER_SETTINGS = "runner.settings";
    private static final String PROJECT_HOME = "project.home";
    private static final String PROJECT_SETTINGS = "project.settings";
    private boolean debugMode = false;

    public static void main(String[] args) {
        new Main().execute(args);
    }

    @VisibleForTesting
    Main() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String[] args) {
        Stats stats = new Stats().start();
        try {
            Properties props = this.loadProperties(args);
            Runner runner = Runner.create(props);
            Logs.info("Runner version: " + Version.getVersion());
            Logs.info("Java version: " + System.getProperty("java.version", "<unknown>") + ", vendor: " + System.getProperty("java.vendor", "<unknown>"));
            Logs.info("OS name: \"" + System.getProperty("os.name") + "\", version: \"" + System.getProperty("os.version") + "\", arch: \"" + System.getProperty("os.arch") + "\"");
            Logs.info("Default locale: \"" + Locale.getDefault() + "\", source code encoding: \"" + runner.getSourceCodeEncoding() + "\"" + (runner.isEncodingPlatformDependant() ? " (analysis is platform dependent)" : ""));
            if (this.debugMode) {
                Logs.info("Other system properties:");
                Logs.info("  - sun.arch.data.model: \"" + System.getProperty("sun.arch.data.model") + "\"");
            }
            Logs.info("Server: " + runner.getSonarServerURL());
            try {
                Logs.info("Work directory: " + runner.getWorkDir().getCanonicalPath());
            }
            catch (IOException e) {
                throw new RunnerException(e);
            }
            runner.execute();
        }
        finally {
            stats.stop();
        }
    }

    @VisibleForTesting
    Properties loadProperties(String[] args) {
        Properties commandLineProps = new Properties();
        commandLineProps.putAll((Map<?, ?>)System.getProperties());
        commandLineProps.putAll((Map<?, ?>)this.parseArguments(args));
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.loadRunnerProperties(commandLineProps));
        result.putAll((Map<?, ?>)this.loadProjectProperties(commandLineProps));
        result.putAll((Map<?, ?>)commandLineProps);
        if (result.containsKey(PROJECT_HOME)) {
            String baseDir = result.getProperty(PROJECT_HOME);
            result.remove(PROJECT_HOME);
            result.put("sonar.projectBaseDir", baseDir);
        }
        return result;
    }

    @VisibleForTesting
    Properties loadRunnerProperties(Properties props) {
        File settingsFile = this.locatePropertiesFile(props, RUNNER_HOME, "conf/sonar-runner.properties", RUNNER_SETTINGS);
        if (settingsFile != null && settingsFile.isFile() && settingsFile.exists()) {
            Logs.info("Runner configuration file: " + settingsFile.getAbsolutePath());
            return this.toProperties(settingsFile);
        }
        Logs.info("Runner configuration file: NONE");
        return new Properties();
    }

    private Properties loadProjectProperties(Properties props) {
        File settingsFile = this.locatePropertiesFile(props, PROJECT_HOME, "sonar-project.properties", PROJECT_SETTINGS);
        if (settingsFile != null && settingsFile.isFile() && settingsFile.exists()) {
            Logs.info("Project configuration file: " + settingsFile.getAbsolutePath());
            return this.toProperties(settingsFile);
        }
        Logs.info("Project configuration file: NONE");
        return new Properties();
    }

    private File locatePropertiesFile(Properties props, String homeKey, String relativePathFromHome, String settingsKey) {
        String settingsPath;
        File settingsFile = null;
        String runnerHome = props.getProperty(homeKey);
        if (runnerHome != null && !"".equals(runnerHome)) {
            settingsFile = new File(runnerHome, relativePathFromHome);
        }
        if (!(settingsFile != null && settingsFile.exists() || (settingsPath = props.getProperty(settingsKey)) == null || "".equals(settingsPath))) {
            settingsFile = new File(settingsPath);
        }
        return settingsFile;
    }

    private Properties toProperties(File file) {
        Properties properties;
        FileInputStream in = null;
        Properties properties2 = new Properties();
        try {
            in = new FileInputStream(file);
            properties2.load(in);
            properties = properties2;
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException("Fail to load file: " + file.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        return properties;
    }

    @VisibleForTesting
    Properties parseArguments(String[] args) {
        Properties props = new Properties();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-h".equals(arg) || "--help".equals(arg)) {
                this.printUsage();
                continue;
            }
            if ("-X".equals(arg) || "--debug".equals(arg)) {
                props.setProperty("sonar.verbose", "true");
                this.debugMode = true;
                continue;
            }
            if ("-D".equals(arg) || "--define".equals(arg)) {
                if (++i >= args.length) {
                    this.printError("Missing argument for option --define");
                }
                arg = args[i];
                this.appendPropertyTo(arg, props);
                continue;
            }
            if (arg.startsWith("-D")) {
                arg = arg.substring(2);
                this.appendPropertyTo(arg, props);
                continue;
            }
            this.printError("Unrecognized option: " + arg);
        }
        return props;
    }

    private void appendPropertyTo(String arg, Properties props) {
        String value;
        String key;
        int j = arg.indexOf(61);
        if (j == -1) {
            key = arg;
            value = "true";
        } else {
            key = arg.substring(0, j);
            value = arg.substring(j + 1);
        }
        props.setProperty(key, value);
    }

    private void printError(String message) {
        Logs.info("");
        Logs.info(message);
        this.printUsage();
    }

    private void printUsage() {
        Logs.info("");
        Logs.info("usage: sonar-runner [options]");
        Logs.info("");
        Logs.info("Options:");
        Logs.info(" -h,--help             Display help information");
        Logs.info(" -X,--debug            Produce execution debug output");
        Logs.info(" -D,--define <arg>     Define property");
        System.exit(0);
    }
}

