/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

final class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOUtils() {
    }

    static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static String toString(Reader input) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.copyLarge(input, sw);
        return sw.toString();
    }

    static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    static long copyLarge(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    static boolean deleteFileQuietly(File file) {
        if (file == null) {
            return false;
        }
        try {
            return file.delete();
        }
        catch (Exception e) {
            return false;
        }
    }
}

