/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.runtime.jvm.plugins;

import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.language.base.plugins.LanguageBasePlugin;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.model.ModelRule;
import org.gradle.model.ModelRules;
import org.gradle.runtime.base.ProjectComponentContainer;
import org.gradle.runtime.base.internal.BinaryNamingSchemeBuilder;
import org.gradle.runtime.base.internal.DefaultBinaryNamingSchemeBuilder;
import org.gradle.runtime.jvm.JvmLibrary;
import org.gradle.runtime.jvm.internal.DefaultJvmLibrary;
import org.gradle.runtime.jvm.internal.plugins.CreateJvmBinaries;
import org.gradle.runtime.jvm.internal.plugins.CreateTasksForJvmBinaries;
import org.gradle.runtime.jvm.internal.plugins.DefaultJvmComponentExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class JvmComponentPlugin
implements Plugin<Project> {
    private final ModelRules modelRules;

    @Inject
    public JvmComponentPlugin(ModelRules modelRules) {
        this.modelRules = modelRules;
    }

    public void apply(Project project) {
        project.getPlugins().apply(LifecycleBasePlugin.class);
        project.getPlugins().apply(LanguageBasePlugin.class);
        ProjectComponentContainer softwareComponents = (ProjectComponentContainer)project.getExtensions().getByType(ProjectComponentContainer.class);
        softwareComponents.registerFactory(JvmLibrary.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<JvmLibrary>(){

            public JvmLibrary create(String name) {
                return new DefaultJvmLibrary(name);
            }
        });
        NamedDomainObjectContainer jvmLibraries = softwareComponents.containerWithType(JvmLibrary.class);
        project.getExtensions().create("jvm", DefaultJvmComponentExtension.class, new Object[]{jvmLibraries});
        this.modelRules.register("jvm.libraries", (Object)jvmLibraries);
        this.modelRules.rule((ModelRule)new CreateJvmBinaries((BinaryNamingSchemeBuilder)new DefaultBinaryNamingSchemeBuilder()));
        this.modelRules.rule((ModelRule)new CreateTasksForJvmBinaries());
    }
}

