/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.model.interpolation;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.mvn3.org.apache.maven.model.Model;
import org.gradle.mvn3.org.apache.maven.model.building.ModelBuildingRequest;
import org.gradle.mvn3.org.apache.maven.model.building.ModelProblem;
import org.gradle.mvn3.org.apache.maven.model.building.ModelProblemCollector;
import org.gradle.mvn3.org.apache.maven.model.interpolation.AbstractStringBasedModelInterpolator;
import org.gradle.mvn3.org.apache.maven.model.interpolation.ModelInterpolator;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Component;
import org.gradle.mvn3.org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.gradle.mvn3.org.codehaus.plexus.interpolation.Interpolator;
import org.gradle.mvn3.org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.gradle.mvn3.org.codehaus.plexus.interpolation.ValueSource;

@Component(role=ModelInterpolator.class)
public class StringSearchModelInterpolator
extends AbstractStringBasedModelInterpolator {
    private static final Map<Class<?>, Field[]> fieldsByClass = new ConcurrentHashMap(80, 0.75f, 2);
    private static final Map<Class<?>, Boolean> fieldIsPrimitiveByClass = new ConcurrentHashMap(62, 0.75f, 2);

    public Model interpolateModel(Model model, File projectDir, ModelBuildingRequest config, ModelProblemCollector problems) {
        this.interpolateObject(model, model, projectDir, config, problems);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interpolateObject(Object obj, Model model, File projectDir, ModelBuildingRequest config, ModelProblemCollector problems) {
        try {
            List<ValueSource> valueSources = this.createValueSources(model, projectDir, config, problems);
            List<? extends InterpolationPostProcessor> postProcessors = this.createPostProcessors(model, projectDir, config);
            InterpolateObjectAction action = new InterpolateObjectAction(obj, valueSources, postProcessors, this, problems);
            AccessController.doPrivileged(action);
        }
        finally {
            this.getInterpolator().clearAnswers();
        }
    }

    protected Interpolator createInterpolator() {
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.setCacheAnswers(true);
        return interpolator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InterpolateObjectAction
    implements PrivilegedAction<Object> {
        private final LinkedList<Object> interpolationTargets;
        private final StringSearchModelInterpolator modelInterpolator;
        private final List<? extends ValueSource> valueSources;
        private final List<? extends InterpolationPostProcessor> postProcessors;
        private final ModelProblemCollector problems;

        public InterpolateObjectAction(Object target, List<? extends ValueSource> valueSources, List<? extends InterpolationPostProcessor> postProcessors, StringSearchModelInterpolator modelInterpolator, ModelProblemCollector problems) {
            this.valueSources = valueSources;
            this.postProcessors = postProcessors;
            this.interpolationTargets = new LinkedList();
            this.interpolationTargets.add(target);
            this.modelInterpolator = modelInterpolator;
            this.problems = problems;
        }

        @Override
        public Object run() {
            while (!this.interpolationTargets.isEmpty()) {
                Object obj = this.interpolationTargets.removeFirst();
                this.traverseObjectWithParents(obj.getClass(), obj);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void traverseObjectWithParents(Class<?> cls, Object target) {
            if (cls == null) {
                return;
            }
            if (cls.isArray()) {
                this.evaluateArray(target);
            } else if (this.isQualifiedForInterpolation(cls)) {
                for (Field currentField : this.getFields(cls)) {
                    Class<?> type = currentField.getType();
                    if (!this.isQualifiedForInterpolation(currentField, type)) continue;
                    Field field = currentField;
                    synchronized (field) {
                        this.interpolateField(cls, target, currentField, type);
                    }
                }
                this.traverseObjectWithParents(cls.getSuperclass(), target);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void interpolateField(Class<?> cls, Object target, Field field, Class<?> type) {
            boolean isAccessible = field.isAccessible();
            field.setAccessible(true);
            try {
                if (String.class == type) {
                    this.interpolateStringField(target, field);
                } else if (Collection.class.isAssignableFrom(type)) {
                    this.interpolateCollectionField(target, field);
                } else if (Map.class.isAssignableFrom(type)) {
                    this.interpolateMapField(target, field);
                } else {
                    Object value = field.get(target);
                    if (value != null) {
                        if (field.getType().isArray()) {
                            this.evaluateArray(value);
                        } else {
                            this.interpolationTargets.add(value);
                        }
                    }
                }
            }
            catch (IllegalArgumentException e) {
                this.problems.add(ModelProblem.Severity.ERROR, "Failed to interpolate field3: " + field + " on class: " + cls.getName(), null, e);
            }
            catch (IllegalAccessException e) {
                this.problems.add(ModelProblem.Severity.ERROR, "Failed to interpolate field4: " + field + " on class: " + cls.getName(), null, e);
            }
            finally {
                field.setAccessible(isAccessible);
            }
        }

        private void interpolateStringField(Object target, Field field) throws IllegalAccessException {
            String value = (String)field.get(target);
            if (value == null || Modifier.isFinal(field.getModifiers())) {
                return;
            }
            String interpolated = this.modelInterpolator.interpolateInternal(value, this.valueSources, this.postProcessors, this.problems);
            if (!interpolated.equals(value)) {
                field.set(target, interpolated);
            }
        }

        private void interpolateCollectionField(Object target, Field field) throws IllegalAccessException {
            Collection c = (Collection)field.get(target);
            if (c == null || c.isEmpty()) {
                return;
            }
            ArrayList originalValues = new ArrayList(c);
            try {
                c.clear();
            }
            catch (UnsupportedOperationException e) {
                return;
            }
            for (Object value : originalValues) {
                if (value == null) {
                    c.add(value);
                    continue;
                }
                if (String.class == value.getClass()) {
                    String interpolated = this.modelInterpolator.interpolateInternal((String)value, this.valueSources, this.postProcessors, this.problems);
                    if (!interpolated.equals(value)) {
                        c.add(interpolated);
                        continue;
                    }
                    c.add(value);
                    continue;
                }
                c.add(value);
                if (value.getClass().isArray()) {
                    this.evaluateArray(value);
                    continue;
                }
                this.interpolationTargets.add(value);
            }
        }

        private void interpolateMapField(Object target, Field field) throws IllegalAccessException {
            Map m = (Map)field.get(target);
            if (m == null || m.isEmpty()) {
                return;
            }
            for (Map.Entry entry : m.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                if (String.class == value.getClass()) {
                    String interpolated = this.modelInterpolator.interpolateInternal((String)value, this.valueSources, this.postProcessors, this.problems);
                    if (interpolated.equals(value)) continue;
                    try {
                        entry.setValue(interpolated);
                    }
                    catch (UnsupportedOperationException e) {}
                    continue;
                }
                if (value.getClass().isArray()) {
                    this.evaluateArray(value);
                    continue;
                }
                this.interpolationTargets.add(value);
            }
        }

        private Field[] getFields(Class<?> cls) {
            Field[] fields = (Field[])fieldsByClass.get(cls);
            if (fields == null) {
                fields = cls.getDeclaredFields();
                fieldsByClass.put(cls, fields);
            }
            return fields;
        }

        private boolean isQualifiedForInterpolation(Class<?> cls) {
            return !cls.getName().startsWith("java");
        }

        private boolean isQualifiedForInterpolation(Field field, Class<?> fieldType) {
            if (Map.class.equals(fieldType) && "locations".equals(field.getName())) {
                return false;
            }
            Boolean primitive = (Boolean)fieldIsPrimitiveByClass.get(fieldType);
            if (primitive == null) {
                primitive = fieldType.isPrimitive();
                fieldIsPrimitiveByClass.put(fieldType, primitive);
            }
            if (primitive.booleanValue()) {
                return false;
            }
            return !"parent".equals(field.getName());
        }

        private void evaluateArray(Object target) {
            int len = Array.getLength(target);
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(target, i);
                if (value == null) continue;
                if (String.class == value.getClass()) {
                    String interpolated = this.modelInterpolator.interpolateInternal((String)value, this.valueSources, this.postProcessors, this.problems);
                    if (interpolated.equals(value)) continue;
                    Array.set(target, i, interpolated);
                    continue;
                }
                this.interpolationTargets.add(value);
            }
        }
    }
}

