/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.plugins;

import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.reporting.GenerateBuildDashboard;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.reporting.ReportingExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class BuildDashboardPlugin
implements Plugin<ProjectInternal> {
    public static final String BUILD_DASHBOARD_TASK_NAME = "buildDashboard";

    public void apply(final ProjectInternal project) {
        project.getPlugins().apply(ReportingBasePlugin.class);
        final GenerateBuildDashboard buildDashboardTask = (GenerateBuildDashboard)project.getTasks().create(BUILD_DASHBOARD_TASK_NAME, GenerateBuildDashboard.class);
        DirectoryReport htmlReport = buildDashboardTask.getReports().getHtml();
        ConventionMapping htmlReportConventionMapping = new DslObject((Object)htmlReport).getConventionMapping();
        htmlReportConventionMapping.map("destination", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ((ReportingExtension)project.getExtensions().getByType(ReportingExtension.class)).file(BuildDashboardPlugin.BUILD_DASHBOARD_TASK_NAME);
            }
        });
        Action<Task> captureReportingTasks = new Action<Task>(){

            public void execute(Task task) {
                if (!(task instanceof Reporting)) {
                    return;
                }
                Reporting reporting = (Reporting)task;
                buildDashboardTask.aggregate(reporting);
                if (!task.equals(buildDashboardTask)) {
                    task.finalizedBy(new Object[]{buildDashboardTask});
                }
            }
        };
        for (Project aProject : project.getAllprojects()) {
            aProject.getTasks().all((Action)captureReportingTasks);
        }
    }
}

