/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.internal;

import com.googlecode.jatl.Html;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.reporting.Report;
import org.gradle.util.GFileUtils;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDashboardGenerator {
    private Set<Report> reports = new TreeSet<Report>(new Comparator<Report>(){

        @Override
        public int compare(Report o1, Report o2) {
            return o1.getDisplayName().compareTo(o2.getDisplayName());
        }
    });
    private File outputFile;

    public BuildDashboardGenerator(Set<Report> reports, File outputFile) {
        this.reports.addAll(reports);
        this.outputFile = outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() {
        try {
            GFileUtils.parentMkdirs((File)this.outputFile);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), "UTF-8"));
            try {
                this.generate(writer);
            }
            finally {
                ((Writer)writer).close();
            }
            this.copyCss();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private void copyCss() {
        GFileUtils.copyURLToFile((URL)this.getClass().getResource("/org/gradle/reporting/base-style.css"), (File)new File(this.outputFile.getParent(), "base-style.css"));
        GFileUtils.copyURLToFile((URL)this.getClass().getResource("style.css"), (File)new File(this.outputFile.getParent(), "style.css"));
    }

    private void generate(Writer writer) {
        new Html(writer){
            {
                this.html();
                this.head();
                ((Html)((Html)this.meta()).httpEquiv("Content-Type")).content("text/html; charset=utf-8");
                ((Html)((Html)((Html)((Html)this.link()).rel("stylesheet")).type("text/css")).href("base-style.css")).end();
                ((Html)((Html)((Html)((Html)this.link()).rel("stylesheet")).type("text/css")).href("style.css")).end();
                ((Html)((Html)this.title()).text("Build dashboard")).end();
                this.end();
                this.body();
                ((Html)this.div()).id("content");
                if (BuildDashboardGenerator.this.reports.size() > 0) {
                    ((Html)((Html)this.h1()).text("Build reports")).end();
                    this.ul();
                    for (Report report : BuildDashboardGenerator.this.reports) {
                        this.li();
                        if (report.getDestination().exists()) {
                            ((Html)((Html)this.a()).href(GFileUtils.relativePath((File)BuildDashboardGenerator.this.outputFile.getParentFile(), (File)BuildDashboardGenerator.this.getHtmlLinkedFileFromReport(report)))).text(report.getDisplayName());
                        } else {
                            ((Html)((Html)this.span()).classAttr("unavailable")).text(report.getDisplayName());
                        }
                        this.end(2);
                    }
                    this.end();
                } else {
                    ((Html)((Html)this.h1()).text("There are no build reports available.")).end();
                }
                this.end();
                ((Html)((Html)this.div()).id("footer")).text(String.format("Generated by %s", GradleVersion.current()));
                this.endAll();
            }
        };
    }

    private File getHtmlLinkedFileFromReport(Report report) {
        if (report instanceof DirectoryReport) {
            return ((DirectoryReport)report).getEntryPoint();
        }
        return report.getDestination();
    }
}

