/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeStoppable
implements Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeStoppable.class);
    private final List<Stoppable> elements = new CopyOnWriteArrayList<Stoppable>();

    public static CompositeStoppable stoppable(Object ... elements) {
        return new CompositeStoppable().add(elements);
    }

    public static CompositeStoppable stoppable(Iterable<?> elements) {
        return new CompositeStoppable().add(elements);
    }

    public CompositeStoppable add(Iterable<?> elements) {
        for (Object element : elements) {
            this.elements.add(CompositeStoppable.toStoppable(element));
        }
        return this;
    }

    public CompositeStoppable add(Object ... elements) {
        for (Object closeable : elements) {
            this.elements.add(CompositeStoppable.toStoppable(closeable));
        }
        return this;
    }

    private static void invoke(Method method, Object target, Object ... args) {
        JavaReflectionUtil.method(target, Object.class, method).invoke(target, args);
    }

    private static Stoppable toStoppable(final Object object) {
        if (object == null) {
            return new Stoppable(){

                public void stop() {
                }
            };
        }
        if (object instanceof Stoppable) {
            return (Stoppable)object;
        }
        if (object instanceof Closeable) {
            final Closeable closeable = (Closeable)object;
            return new Stoppable(){

                public String toString() {
                    return closeable.toString();
                }

                public void stop() {
                    try {
                        closeable.close();
                    }
                    catch (IOException e) {
                        throw UncheckedException.throwAsUncheckedException(e);
                    }
                }
            };
        }
        return new Stoppable(){

            public String toString() {
                return object.toString();
            }

            public void stop() {
                try {
                    CompositeStoppable.invoke(object.getClass().getMethod("stop", new Class[0]), object, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                try {
                    CompositeStoppable.invoke(object.getClass().getMethod("close", new Class[0]), object, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Throwable failure = null;
        try {
            for (Stoppable element : this.elements) {
                try {
                    element.stop();
                }
                catch (Throwable throwable) {
                    if (failure == null) {
                        failure = throwable;
                        continue;
                    }
                    LOGGER.error(String.format("Could not stop %s.", element), throwable);
                }
            }
        }
        finally {
            this.elements.clear();
        }
        if (failure != null) {
            throw UncheckedException.throwAsUncheckedException(failure);
        }
    }
}

