/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.plugins;

import java.util.Iterator;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.internal.artifacts.ArtifactPublicationServices;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.DefaultProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.DefaultPublicationContainer;
import org.gradle.api.publish.internal.DefaultPublishingExtension;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.ModelPath;
import org.gradle.model.ModelRule;
import org.gradle.model.ModelRules;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class PublishingPlugin
implements Plugin<Project> {
    public static final String PUBLISH_TASK_GROUP = "publishing";
    public static final String PUBLISH_LIFECYCLE_TASK_NAME = "publish";
    private final Instantiator instantiator;
    private final ModelRules modelRules;
    private final ArtifactPublicationServices publicationServices;
    private final ProjectPublicationRegistry publicationRegistry;

    @Inject
    public PublishingPlugin(ArtifactPublicationServices publicationServices, Instantiator instantiator, ModelRules modelRules, ProjectPublicationRegistry publicationRegistry) {
        this.publicationServices = publicationServices;
        this.instantiator = instantiator;
        this.modelRules = modelRules;
        this.publicationRegistry = publicationRegistry;
    }

    public void apply(final Project project) {
        RepositoryHandler repositories = this.publicationServices.createRepositoryHandler();
        PublicationContainer publications = (PublicationContainer)this.instantiator.newInstance(DefaultPublicationContainer.class, new Object[]{this.instantiator});
        final PublishingExtension extension = (PublishingExtension)project.getExtensions().create(PUBLISH_TASK_GROUP, DefaultPublishingExtension.class, new Object[]{repositories, publications});
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                Iterator i$ = extension.getPublications().iterator();
                while (i$.hasNext()) {
                    Publication publication = (Publication)i$.next();
                    PublicationInternal internalPublication = (PublicationInternal)publication;
                    PublishingPlugin.this.publicationRegistry.registerPublication(project.getPath(), (ProjectPublication)new DefaultProjectPublication(internalPublication.getCoordinates()));
                }
            }
        });
        ModelPath extensionModelPath = ModelPath.path((String)PUBLISH_TASK_GROUP);
        this.modelRules.register(extensionModelPath.toString(), (Object)extension);
        this.modelRules.rule(new ModelRule(){

            public void triggerDeferredConfigurables(PublishingExtension publishingExtension) {
                project.getExtensions().getByType(DefaultPublishingExtension.class);
            }
        });
        Task publishLifecycleTask = project.getTasks().create(PUBLISH_LIFECYCLE_TASK_NAME);
        publishLifecycleTask.setDescription("Publishes all publications produced by this project.");
        publishLifecycleTask.setGroup(PUBLISH_TASK_GROUP);
    }
}

