/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl.steps;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.change.Change;
import org.gradle.internal.change.ChangeVisitor;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.impl.steps.Context;
import org.gradle.internal.execution.impl.steps.SnapshotResult;
import org.gradle.internal.execution.impl.steps.Step;
import org.gradle.internal.execution.impl.steps.UpToDateResult;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipUpToDateStep<C extends Context>
implements Step<C, UpToDateResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipUpToDateStep.class);
    private static final ImmutableList<String> NO_HISTORY = ImmutableList.of((Object)"No history is available.");
    private final Step<? super C, ? extends SnapshotResult> delegate;

    public SkipUpToDateStep(Step<? super C, ? extends SnapshotResult> delegate) {
        this.delegate = delegate;
    }

    @Override
    public UpToDateResult execute(C context) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Determining if {} is up-to-date", (Object)context.getWork().getDisplayName());
        }
        return context.getWork().getChangesSincePreviousExecution().map(changes -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            MessageCollectingChangeVisitor visitor = new MessageCollectingChangeVisitor((ImmutableCollection.Builder<String>)builder, 3);
            changes.visitAllChanges(visitor);
            ImmutableList reasons = builder.build();
            if (reasons.isEmpty()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Skipping {} as it is up-to-date.", (Object)context.getWork().getDisplayName());
                }
                return new UpToDateResult((ExecutionStateChanges)changes){
                    final /* synthetic */ ExecutionStateChanges val$changes;
                    {
                        this.val$changes = executionStateChanges;
                    }

                    @Override
                    public ImmutableList<String> getOutOfDateReasons() {
                        return ImmutableList.of();
                    }

                    public ImmutableSortedMap<String, FileCollectionFingerprint> getFinalOutputs() {
                        return this.val$changes.getPreviousExecution().getOutputFileProperties();
                    }

                    @Override
                    public OriginMetadata getOriginMetadata() {
                        return this.val$changes.getPreviousExecution().getOriginMetadata();
                    }

                    @Override
                    public ExecutionOutcome getOutcome() {
                        return ExecutionOutcome.UP_TO_DATE;
                    }

                    @Override
                    @Nullable
                    public Throwable getFailure() {
                        return null;
                    }
                };
            }
            return this.executeBecause((ImmutableList<String>)reasons, context);
        }).orElseGet(() -> this.executeBecause(NO_HISTORY, context));
    }

    private UpToDateResult executeBecause(final ImmutableList<String> reasons, C context) {
        this.logOutOfDateReasons((List<String>)reasons, context.getWork());
        final SnapshotResult result = this.delegate.execute(context);
        return new UpToDateResult(){

            @Override
            public ImmutableList<String> getOutOfDateReasons() {
                return reasons;
            }

            @Override
            public ImmutableSortedMap<String, ? extends FileCollectionFingerprint> getFinalOutputs() {
                return result.getFinalOutputs();
            }

            @Override
            public OriginMetadata getOriginMetadata() {
                return result.getOriginMetadata();
            }

            @Override
            public ExecutionOutcome getOutcome() {
                return result.getOutcome();
            }

            @Override
            @Nullable
            public Throwable getFailure() {
                return result.getFailure();
            }
        };
    }

    private void logOutOfDateReasons(List<String> reasons, UnitOfWork work) {
        if (LOGGER.isInfoEnabled()) {
            Formatter formatter = new Formatter();
            formatter.format("%s is not up-to-date because:", StringUtils.capitalize((String)work.getDisplayName()));
            for (String message : reasons) {
                formatter.format("%n  %s", message);
            }
            LOGGER.info(formatter.toString());
        }
    }

    private static class MessageCollectingChangeVisitor
    implements ChangeVisitor {
        private final ImmutableCollection.Builder<String> messages;
        private final int max;
        private int count;

        public MessageCollectingChangeVisitor(ImmutableCollection.Builder<String> messages, int max) {
            this.messages = messages;
            this.max = max;
        }

        public boolean visitChange(Change change) {
            this.messages.add((Object)change.getMessage());
            return ++this.count < this.max;
        }
    }
}

